
$(function () {

	var pom_mins = localStorage.pom_mins || 25,
		pom_short = localStorage.pom_short || 5,
		pom_long = localStorage.pom_long || 15;
	
	// Backbone Views	
	var TimerView = Backbone.View.extend({
		el: 'body',
		template: _.template(
			'<section id="index" data-position="current">' +
					'<section data-type="sidebar">' +
						'<header>' +
							'<menu type="toolbar">' +
								'<a href="#">Done</a>' +
							'</menu>' +
							'<h1>Menu</h1>' +
						'</header>' +
						'<nav>' +
							'<ul>' +
								'<li><a id="btn-timer" href="#">Timer</a></li>' +
								'<li><a id="btn-info" href="#/info">Info</a></li>' +
								'<li><a id="btn-settings" href="#/settings">Settings</a></li>' +
								//'<li><a id="btn-about" href="#/about">About</a></li>' +
							'</ul>' +
						'</nav>' +
					'</section>' +
		'' +
					'<!--........................ Drawer ...............................-->' +
					'<section id="drawer" role="region">' +
						'<header class="fixed">' +
							'<a href="#"><span class="icon icon-menu">hide sidebar</span></a>' +
							'<a href="#drawer"><span class="icon icon-menu">show sidebar</span></a>' +
							'<menu type="toolbar"><button id="btn-stop">Stop</button></menu>' +
							'<h1>PomodoroTime</h1>' +
						'</header>' +
						'<article id="selected" class="content scrollable header">' +
							'<header><h2>Pomodoro count: <span id="count">0</span></h2></header>' +
								'<div id="clock">' +
								'<div><span id="mins">25</span>m</div>' +
								'<div><span id="secs">00</span>s</div>' +
								'</div>' +
								'<button id="btn-start">Start</button>' +
						'</article>' +
					'</section> <!-- end drawer -->' +
		'' +
				'</section> <!-- end index -->' +

				// Confirmation
				'<section id="confirm" data-position="back" class="fade-out">' +
					'<form role="dialog" data-type="confirm">' +
						'<section>' +
							'<h1>Confirmation</h1>' +
							'<p>Are you sure you want to stop the timer?</p>' +
						'</section>' +
						'<menu>' +
							'<button id="btn-confirm">Yes</button>' +
							'<button id="btn-cancel">Cancel</button> ' +
						'</menu>' +
					'</form>' +
				'</section>'
		),

		events: {
			'click #btn-start': 'start',
			'click #btn-stop': 'stop',
			'click #btn-confirm': 'confirm',
			'click #btn-cancel': 'cancel'
		},

		initialize: function () {
			$('body').html(this.el);

			this.render();

			// Initialize POMODORO
			pom.init($('#mins'), $('#secs'), $('#btn-start'), $('#count'));
		},

		render: function () {
			this.$el.html(this.template());
		},

		start: function (event) {
			pom.start();
		},

		stop: function (event) {
			//if(pom.isRunning() === true){
			//	document.querySelector('#confirm').className = 'fade-in';
			//} else {
				pom.stop();
			//}
		},

		confirm: function (event) {
			pom.stop();
		},

		cancel: function (event) {
			document.querySelector('#confirm').className = 'fade-out';
		}
	});
	
	var SettingsView = Backbone.View.extend({
		template: _.template(
			'<header><h2>Pomodoro Minutes: <input id="minLabel" type="number" class="settings-label"></input>m</h2></header>' +
				'<div id="minSlider"></div>' +
				'<header><h2>Short Break: <input id="shortLabel" type="number" class="settings-label"></input>m</h2></header>' +
				'<div id="shortSlider"></div>' +
				'<header><h2>Long Break: <input id="longLabel" type="number" class="settings-label"></input>m</h2></header>' +
				'<div id="longSlider"></div>' +
				'<div class="settings-btns">' +
					'<div class="half">' +
						'<button id="btn-save">Save</button>' +
					'</div>' +
					'<div class="half">' +
					'<button id="btn-default" class="danger">Default</button>' +
					'</div>' +
				'</div>'
		),
		events: {
			'click #btn-save': 'save',
			'click #btn-default': 'defaults'
		},
		initialize: function () {
			$("#selected").html(this.el);
			this.render();

			// Configure settings sliders
			var $minLabel = $('#minLabel'),
				$shortLabel = $('#shortLabel'),
				$longLabel = $('#longLabel');

			$('#minSlider').noUiSlider({
				range: [1, 60],
				start: [25],
				handles: 1,
				step: 1,
				serialization: {
					resolution: 1,
					to: $minLabel
				}
			});

			$('#shortSlider').noUiSlider({
				range: [1, 5],
				start: [5],
				handles: 1,
				step: 1,
				serialization: {
					resolution: 1,
					to: $shortLabel
				}
			});

			$('#longSlider').noUiSlider({
				range: [1, 30],
				start: [15],
				handles: 1,
				step: 1,
				serialization: {
					resolution: 1,
					to: $longLabel
				}
			});

			//Initialize sliders
			$('#minSlider').val(pom_mins);
			$('#shortSlider').val(pom_short);
			$('#longSlider').val(pom_long);
		},
		render: function () {
			this.$el.html(this.template());
		},

		save: function () {
			pom_mins = localStorage.pom_mins = $('#minSlider').val();
			pom_short = localStorage.pom_short = $('#shortSlider').val();
			pom_long = localStorage.pom_long = $('#longSlider').val();

			//Stop pomodoro
			pom.stop();

			$('header.fixed h1').append("<section role='status'><p>Changes <strong>saved</strong>.</p></section>");

			setTimeout(function () {
				$('[role="status"]').remove();
			}, 2000);
		},

		defaults: function () {
			pom_mins = localStorage.pom_mins = 25;
			pom_short = localStorage.pom_short = 5;
			pom_long = localStorage.pom_long = 15;

			$('#minSlider').val(pom_mins);
			$('#shortSlider').val(pom_short);
			$('#longSlider').val(pom_long);

			//Stop pomodoro
			pom.stop();

			$('header.fixed h1').append("<section role='status'><p>Default settings loaded.</p></section>");

			setTimeout(function () {
				$('[role="status"]').remove();
			}, 2000);
		}
	});
	
	var InfoView = Backbone.View.extend({
		template: _.template(
			'<header><h2>Info</h2></header>' +
				'<p>' +
				"<strong>This app doesn't run on background</strong>, to avoid suspend the app go to 'settings' menu of the Operating System, and set up 'waiting time > never' on 'Display' menu. <strong>Otherwise timer won't ring.</strong>" +
				'</p>'+
				'<p>' +
				'Five basic steps to start using Pomodoro Technique:' +
				'</p>' +
				'<ul>' +
					'<li>1. decide on the task to be done</li>' +
					'<li>2. start the pomodoro timer</li>' +
					'<li>3. work on the task until the timer rings</li>' +
					'<li>4. take a short break (5 minutes)</li>' +
					'<li>5. every four pomodoros take a longer break (15–30 minutes)</li>' +
				'</ul>' +
				'<p>' +
				'By default the pomodoro timer is configured to 25min, short breaks are configured to 5min and long breaks are configured to 15min. Also you can change all parameters on settings screen.' +
				'</p>'
		),
		initialize: function () {
			$("#selected").html(this.el);
			this.render();
		},
		render: function () {
			this.$el.html(this.template());
		}
	});
	
	var AboutView = Backbone.View.extend({
		template: _.template('<h1>About</h1>'),
				
		events: {
			'click h1': 'fire'
		},
		initialize: function () {
			$("#selected").html(this.el);
			this.render();
		},
		render: function () {
			this.$el.html(this.template());
		},

		fire: function () {
			alert('fire!');
		}
	});

	var Router = Backbone.Router.extend({
		routes : {
			"" : "home",
			"settings" : "settings",
			"info" : "info",
			"about" : "about"
		},

		home : function () {
			this.view = new TimerView();
		},
		
		settings : function () {
			this.view = new SettingsView();
		},

		info : function () {
			this.view = new InfoView();
		},

		about : function () {
			this.view = new AboutView();
		}
	});

	//Init pomodoro
	pom.clearTimer(pom_mins);
	pom.setBreak(pom_short);
	pom.setLongBreak(pom_long);

	var router = new Router();
	Backbone.history.start();
});
