String.prototype.repeat = function (num) {
    return new Array(num + 1).join(this);
}

var pom = (function () {
	"use strict";
	
	//Private atributes
	var miliseconds,
		$min,
		$sec,
		$lab,
		$count,
		timer_id,
		isRunning,
		isBreak,
		pomDur,
		breakDur,
		longBreakDur,
		count = 0;

	// Private methods
	var timer = function () {
			var frec = 100,
				fn = function () {
					var str_min,
						str_sec,
						minutes,
						seconds;
					if (miliseconds > 0) {
						miliseconds -= frec;
					} else {

						pom.playDingDong();

						if (!isBreak) {
							count = count + 1;
							$count.text(count);
						}

						isBreak = !isBreak;

						if (isBreak) {
							$('#mins').addClass('freetime');
							$('#secs').addClass('freetime');
							if (count % 4 === 0) {
								pom.playLongBreak();
								
								eventLongBreak();
							} else {
								pom.playBreak();
							}
						} else {
							$('#mins').removeClass('freetime');
							$('#secs').removeClass('freetime');
							pom.stop();

							eventPomodoro();
						}
					}

					// UI Changes
					minutes = pom.getMins(2);
					seconds = pom.getSeconds(2);

					$min.text(minutes);
					$min.data('text', minutes);

					$sec.text(seconds);
					$sec.data('text', seconds);
				};

			if (!isRunning) {
				timer_id = setInterval(fn, frec);
				isRunning = true;
			}
		};

	return {
		init : function ($minutes, $seconds, $label, $counter) {
			$min = $minutes;
			$sec = $seconds;
			$lab = $label;
			$count = $counter;

			$min.text(this.getMins(2));
			$sec.text(this.getSeconds(2));
			$count.text(this.getCount());
		},

		// Set number of mins of the pom timer
		clearTimer : function (mins) {
			miliseconds = mins * 60 * 1000;
		},

		setBreak : function (mins) {
			breakDur = mins;
		},

		setLongBreak : function (mins) {
			longBreakDur = mins;
		},

		setMiliseconds: function (milisec) {
			miliseconds = milisec;
		},

		getBreak : function () {
			return breakDur;
		},

		getLongBreak : function () {
			return longBreakDur;
		},

		// Return mins
		getMins : function (digits) {
			var dig = digits || 0,
				aux,
				zero = '0',
				mins = Math.floor(miliseconds / (1000 * 60));

			if (mins < 0) mins = 0;

			if (dig > 0) {
				dig -= 1;
				aux = Math.pow(10, dig);

				if( mins < aux ){
					mins =	zero.repeat(dig) + mins; 
				}
			}
			return mins;
		},

		// Return seconds
		getSeconds : function (digits) {
			var dig = digits || 0,
				aux,
				zero = '0',
				seconds =  Math.floor((miliseconds / 1000) - 60 * pom.getMins());

			if (seconds < 0) seconds = 0;

			if (dig > 0) {
				dig -= 1;
				aux = Math.pow(10, dig);

				if( seconds < aux ){
					seconds =	zero.repeat(dig) + seconds; 
				}
			}
			return seconds;
		},

		getMiliseconds : function () {
			return miliseconds;
		},

		getCount : function () {
			return count;
		},

		isRunning : function () {
			return isRunning;
		},

		isBreak : function () {
			return isBreak;
		},

		// Esta función podría ser privada...
		playTicTac : function () {
			$('audio').remove();
			var audio = document.createElement('audio');
			audio.src = 'audio/tic-tac.ogg';
			audio.controls = false;
			audio.hidden = true;
			audio.autoplay = "autoplay";
			document.body.appendChild(audio);
		},

		playDingDong : function () {
			$('audio').remove();
			var audio = document.createElement('audio');
			audio.src = 'audio/ding-dong.ogg';
			audio.controls = false;
			audio.hidden = true;
			audio.autoplay = "autoplay";
			document.body.appendChild(audio);

			if('vibrate' in navigator) {
				// ... vibrate
				navigator.vibrate(300);
			}
		},

		playBreak : function () {
			breakDur = localStorage.pom_short || 5;
			pom.clearTimer(breakDur);
			isBreak = true;
		},

		playLongBreak : function () {
			longBreakDur = localStorage.pom_long || 15;
			pom.clearTimer(longBreakDur);
			isBreak = true;
		},

		playPom : function () {
			pomDur = localStorage.pom_mins || 25;
			pom.clearTimer(pomDur);
			isBreak = false;
		},

		// start / pause
		start: function () {
			if (isRunning) {
				isRunning = false;
				clearInterval(timer_id);
				$lab.text('Start');
			} else {
				pom.playTicTac();
				timer();
				$lab.text('Pause');
			}
		},

		stop : function () {
			this.playPom();
			clearInterval(timer_id);
			isRunning = false;

			// UI Changes
			$min.text(this.getMins(2));
			$min.removeClass('freetime');
			$sec.text(this.getSeconds(2));
			$sec.removeClass('freetime');
			$lab.text('Start');
		}

	};

}());
