// Create the canvas
var canvas = document.getElementById("canvas1");
var soundWall = new Audio("wall.ogg");
var soundPing = new Audio("ping.ogg");
var soundLongPing = new Audio("longping.ogg");
var beep = new Audio("beep.wav");
window.requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame ||
                              window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
fss= document.documentElement.requestFullScreen||document.documentElement.msRequestFullScreen||document.documentElement.mozRequestFullscreen||document.documentElement.webkitRequestFullScreen;

if (screen.width > 400)  
	document.getElementById("viewport").setAttribute('content', 'initial-scale=1.5');
				
if (screen.width > 500)
	document.getElementById("viewport").setAttribute('content', 'initial-scale=1.7');

var interval=0;
				
function play(){	
beep.currentTime=0;
		beep.play();
		}			  
var ctx = canvas.getContext("2d");
ctx.font="16px Georgia";
canvas.width = 300;
canvas.height = 450;
var speed = 10;
if (typeof localStorage["vibrations"]=='undefined')
	{
	localStorage["vibrations"]='On';
	vibrations=1;	
	}
else {
	if(localStorage['vibrations']==='On')
		var vibrations=1;
	else 
		var vibrations=0;
	
	}
	
if (typeof localStorage["sounds"]=='undefined')
	{
	localStorage["sounds"]='On';
	var sounds=1;
	}
else {
	if(localStorage['sounds']==='On')
		var sounds=1;
	else 
		var sounds=0;
	
	}	
	
if (typeof localStorage["pvp"]=='undefined'){
	localStorage["pvp"]='0';
	var pvp=0;
	}
else {
	if(localStorage['pvp']==='0')
		var pvp=0;
	else 
		var pvp=1;
	
	}

if (typeof localStorage["pointstowin"]=='undefined'){

		localStorage['pointstowin']=10;
}
var fs=0;
var cw = canvas.width;
var ch = canvas.height;
var lastwinner=1; //1 for top player
var i=0; var j=1;    var left=0;
// Game objects
var aileft=2;
var player = {
x:cw/2-25,
prevx:0,
left:0,
prevy:0,
y:ch - 35,
height:15,
size:6,
points:0,
width:50,
speed: 350 // movement in pixels per second
};
var playertop = {
x:cw/2-25,
prevx:0,
prevy:0,
height:15,
y:10,
size:10, 
points:0,
left:0,
width:50,
speed: 350
};             
var ball = {
dotek:0,
direction:0,
x:150,
y:100,
radius:7,
prevx:0,
prevy:0,
speed :220
};                                                                                                                                                    

                                                                                                                                                                   
// Handle keyboard controls
var keysDown = {};

addEventListener("keydown", function (e) {
	keysDown[e.keyCode] = true;
}, false);

addEventListener("keyup", function (e) {
	delete keysDown[e.keyCode];
}, false);




// Update game objects
var update = function (modifier) {
	
	//modifier=0.01;
	if (pvp==0)
		ai();
	
	
	if (37 in keysDown || player.left==1 ) { // Player holding left
		player.x -= Math.round(player.speed * modifier);
		
	}

	if (39 in keysDown || player.left==-1 ) { // Player holding right
		player.x += Math.round(player.speed * modifier);
	}                               
   /////////player top
   
	if (65 in keysDown || playertop.left==1 || aileft==1) { // Player holding left
		playertop.x -= Math.round(playertop.speed * modifier);
	}
	if (68 in keysDown || playertop.left==-1 || aileft==0) { // Player holding right
		playertop.x += Math.round(playertop.speed * modifier);
	}
	
	
	ball.x += Math.round(ball.speed *modifier * i) ;
	ball.y += Math.round(ball.speed *modifier * j) ; 
	//ball.direction= Math.atan(  Math.abs(ball.y- ball.beforey)  /  Math.abs(ball.x -ball.beforex) )/ Math.PI * 180;
	//document.getElementById("uhel").innerHTML=ball.direction;
	
	colide();
};

// Draw everything
var render = function () {
 //canvas.width=cw;
	 x = requestAnimationFrame(render);
	ctx.fillStyle="#ffffff";
	ctx.fillRect(0,0,cw,ch);
	//ctx.arc(ball.prevx,ball.prevy,ball.radius+1,0,2*Math.PI);
	
	
	//ctx.fillRect(player.prevx-1,player.prevy,player.width+2,player.height);
	
	//ctx.fillRect(playertop.prevx-1,playertop.prevy,playertop.width+2,playertop.height);
	
	

	ctx.beginPath();
	ctx.fillStyle="#000000";
	ctx.arc(ball.x,ball.y,ball.radius,0,2*Math.PI);
	ball.prevx=ball.x;
	ball.prevy=ball.y;
	ctx.fillRect(player.x,player.y,player.width,player.height);
	ctx.fillRect(playertop.x,playertop.y,playertop.width,playertop.height);
	player.prevx=player.x;
	
	playertop.prevx=playertop.x;
	
	
	ctx.fillText(player.points,5,ch/2 - 10);
	ctx.fillText(playertop.points,cw - 20,ch/ 2 - 10);
	ctx.fill();
	ctx.closePath();
 
};

// The main game loop
var main = function () {
	var now = Date.now();
	var delta = now - then;
	//if(delta >0.02)
	update(delta / 1000);
 	
	then = now;
	
};



function colide(){
	//if (ball.)

	if(ball.x + ball.radius > cw){
		ball.x=cw-ball.radius;
		i*=-1;
		if(sounds===1)soundWall.play();
		if (vibrations === 1) vib(20);
	}
	else if(ball.x - ball.radius < 0){
		i*=-1;	
		ball.x=ball.radius;
		if (sounds === 1)
			soundWall.play();
		if (vibrations === 1) 
			vib(20);
	}
	if(player.x < 0 ) player.x=0;
	if (player.x > cw - player.width ) player.x = cw - player.width;
	if(playertop.x < 0 ) playertop.x=0;
	if (playertop.x > cw - playertop.width) playertop.x = cw - playertop.width;
	
	//colide bottom player
	
	if( ball.y + ball.radius >= player.y && ball.x+ball.radius >= player.x  && ball.x-ball.radius <= player.x+player.width &&
			ball.y+ball.radius <= player.y+player.height ){
			if( sounds )soundPing.play();
			if (vibrations === 1) vib(50);
			if( player.x+player.width/2 < ball.x)
				{
				i=1;
				}
			else
				i=-1;
			
			if ( ball.x - player.x < 10 || ball.x - player.x> 40  ) {
				j=-0.9;
				i*=2;
				
				}
			else if ( ( ball.x - player.x>= 10 && ball.x - player.x<= 20 ) ||
						( ball.x - player.x>= 30 && ball.x - player.x <= 40 ) ) {
						j= -1.7;
						
						}
			else if (ball.x - player.x > 20 && ball.x - player.x < 30 ){
						j=-1.5;
						i=0;
						}
				ball.y=player.y - 2 - ball.radius;
					
					
		}
		
	//point for bot
	else if ( ball.y > ch){
				playertop.points++;
				lastwinner=0;
				newStage();
			}
	//point for top
	else if ( ball.y < 0){
				lastwinner=1;
				player.points++;
				newStage();
				
			}
		
	
		
		
	// colide top player
	if( ball.y - ball.radius <= playertop.y+playertop.height && ball.x+ball.radius > playertop.x  && ball.x-ball.radius < playertop.x+playertop.width && 
			ball.y-ball.radius >= playertop.y)
		{
			if( sounds )soundPing.play();
			if (vibrations === 1) vib(50);
			if( playertop.x+playertop.width/2 < ball.x)
				{
				i=1;
				}
			else
				i=-1;
					
			if ( ball.x - playertop.x < 10 || ball.x - playertop.x> 40  ) {
				j=0.9;
				i*=2;	
				}
			else if ( ( ball.x - playertop.x>= 10 && ball.x - playertop.x<= 20 ) ||
						( ball.x - playertop.x>= 30 && ball.x - playertop.x <= 40 ) ) {
						j= 1.7;
						//i=1;
						}
			else if (ball.x - playertop.x > 20 && ball.x - playertop.x < 30 ){
						j=1.5;
						i=0;
						}
				ball.y=playertop.y + 2 + playertop.height  + ball.radius;
					
		}	
};

function newStage(){
			//console.log(max);
			//max = 0;
			
			ls=localStorage['pointstowin'];
			// not end game
			if( player.points <ls && playertop.points < ls){
				ball.x=cw/2;
				ball.y=ch/2;
				//clear score underground
				ctx.beginPath();
				ctx.fillStyle="#ffffff";
				ctx.rect(5,ch/2-20,100,50);
				ctx.rect(cw-20,ch/2-20,100,50);
				ctx.closePath();
				ctx.fill();
				ctx.font="16px Georgia";
				i = 0;
				j = 0;
				left=0;
				setTimeout(function() 
							{
							if( lastwinner )//loser start new stage
							{
							i=0;j=-1;
							}
							else 
							{
							i=0;j=1;
							}
							},2000);
			
			}
			//end of the game
			else{
			
				stop();
				
				gameover();
			}
};

function ai(){
			
			if(  ball.x - (playertop.x+playertop.width*0.2/2 ) < -2 )
				aileft=1;
			else{
				if ( ball.x - ( playertop.x+playertop.width*1.8/2 ) > 2 )
					aileft=0;
				else  aileft=-1;
				}
};
function vib(ms)
{
if('vibrate' in navigator) {
    
    navigator.vibrate(ms);
}
};
function handleStart(evt){
			
		 if(evt.changedTouches[0].pageY > ch/2 )
			player.left=-1;
			
		
		if(evt.changedTouches[0].pageY < ch/2 )
			if(pvp===1)
				playertop.left=-1;
		};
function handleEnd(evt){
		if(evt.changedTouches[0].pageY > ch/2 )
			player.left=1;
		else 
			if (evt.changedTouches[0].pageY < ch/2 )
			if(pvp===1)
				playertop.left=1;
			else
				playertop.left=0;
};
 window.addEventListener("touchend", handleEnd, false);
 window.addEventListener("touchstart", handleStart, false);
 window.addEventListener("touchmove", handleStart, false);
 
 
 
 
 function stop(){
	cancelAnimationFrame(x);
	clearInterval(interval);
 
 };
  function changePointsToWin(){
	  play();
	  ls =parseInt(localStorage['pointstowin']);
		if (ls>14)
		localStorage['pointstowin']=1;
		else{
			localStorage['pointstowin']=ls+1;
			document.getElementById('points-to-win').innerHTML=localStorage['pointstowin'];
		}
		document.getElementById('points-to-win').innerHTML=localStorage['pointstowin'];
		
 
 }
 function changeVibrations(){
	if (sounds === 1)
		play();
	 if (localStorage['vibrations']=='On'){
		localStorage.setItem('vibrations','Off');
		vibrations=0;
		document.getElementById('option-vibrations').innerHTML="Off";
		
	}
	else {
		vibrations=1;
		localStorage.setItem('vibrations',"On");
		document.getElementById('option-vibrations').innerHTML="On";
		
 }
 }
 function changeSounds(){
		
	  if (localStorage['sounds']=='On'){
		localStorage.setItem('sounds','Off');
		//document.getElementById('sound').pause();
		document.getElementById('option-sounds').innerHTML="Off";
		sounds=0;
	}
	else {
		
		play();
		localStorage.setItem('sounds','On');
		//document.getElementById('sound').play();
		document.getElementById('option-sounds').innerHTML="On";
		sounds=1;
		
 }
 
 }
 function showOptions(){
 if (sounds === 1)
	play();
	 
 document.getElementById('menu').hidden=true;
 
 document.getElementById('options').hidden = false;
 
 //document.getElementById('gameover').hidden = true;
 document.getElementById('game').hidden = true;
document.getElementById('option-sounds').innerHTML=localStorage["sounds"];
document.getElementById('points-to-win').innerHTML=localStorage["pointstowin"];

document.getElementById('option-vibrations').innerHTML=localStorage["vibrations"];
if (pvp===0)
	document.getElementById('against').innerHTML="AI";
else
	document.getElementById('against').innerHTML='Player';
	 
 }
 function showMenu(){
	if (sounds === 1)
		play();
 document.getElementById('options').hidden = true;
 document.getElementById('menu').hidden = false;
 document.getElementById('gameover').hidden = true;
 document.getElementById('game').hidden = true;
 }
 function setPvp(){
	if (sounds === 1)
		play();
	if (pvp==0){
		document.getElementById("against").innerHTML="Player";
		pvp = 1;
		localStorage['pvp']='1';
		}
	else 
	{
		document.getElementById("against").innerHTML="AI"
		pvp =0;
		localStorage['pvp']='0';
	}
 }
 function gameover(){
			stop();
			//ctx.clearRect(0,0,cw,ch);
			
 document.getElementById('menu').hidden = true;
 
 document.getElementById('game').hidden = true;
 document.getElementById('gameover').hidden = false;
			if(playertop.points>player.points){
				
				document.getElementById('score').innerHTML =((pvp===0)?'AI':'Top player')+" win!";
				playertop.points=0;
				player.points=0;
				}
			else{
				document.getElementById('score').innerHTML ="Bottom player win!";
				playertop.points=0;
				player.points=0;
			
				}
			//ctx.font="12px Georgia";
  };
  
 function start(){
	if (sounds === 1)
		play();
  ball.x=150;
 ball.y=100;
 i = 0;
 j = 1;
 x=requestAnimationFrame(render);
 then = Date.now();
 interval = setInterval(main, speed); 

 document.getElementById('menu').hidden = true;
 
 document.getElementById('gameover').hidden = true;
 document.getElementById('game').hidden = false;
 
  };
