﻿/**
* @ContributorsList
* @Inateno / http://inateno.com / http://dreamirl.com
*
***
simple Game class declaration example
**/

define( [ 'DREAM_ENGINE', 'DE.GuiLabel', 'DE.GuiImage', 'DE.GamePad' ],
function( DreamE, GuiLabel, GuiImage, GamePad )
{
  var Game = {};
  
  Game.render  = null;
  Game.scene  = null;
  var _counter = null;
  var _timer = null;
  var screenW = 1280, screenH = 720;
  
  var _score = null;
  var _finalScore = {
    "endGame": 0
    , "1" : null
    , "2" : null
  };
  // init
  Game.init = function()
  {
    DreamE.CONFIG.DEBUG_LEVEL = 0;
    DreamE.CONFIG.DEBUG = false;
    // render
    Game.render = new DreamE.Render( "render", { width: screenW, height: screenH , fullScreen: "ratioStretch"} );
    Game.render.init();
    
    DreamE.start();
  }
  
  // start
  Game.start = function()
  {
    Game.scene = new DreamE.Scene( "Test", { backgroundColor: "black" } );
    
    // camera
    Game.camera = new DreamE.Camera( screenW, screenH, 0, 0, { 'name': "Test zoom 100%", 'backgroundColor': "#6a0000" } );
    Game.camera.scene = Game.scene;
    Game.camera.gui = new DreamE.Gui( Game.camera, { 'id': "Test" } );
    
    Game.render.add( Game.camera );
    
    var bg = new DreamE.GameObject( {
      "name": "bg", "tag": "bg", "zindex": 0
      , "x": screenW / 2, "y": screenH / 2
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "field" } )
    } );
    var bgtop = new DreamE.GameObject( {
      "name": "bgtop", "tag": "bg", "zindex": 1
      , "x": screenW / 2, "y": screenH / 2
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "field_top", "alpha": 0.01 } )
    } );
    var bgbot = new DreamE.GameObject( {
      "name": "bgbot", "tag": "bg", "zindex": 1
      , "x": screenW / 2, "y": screenH / 2
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "field_bot", "alpha": 0.01 } )
    } );
    bg.variation = fadeVariation;
    bg.maxFade = 1; bg.minFade = 0.6;bg.fadeSpeed = 0.05;bg.fading = true;
    bgtop.variation = fadeVariation;
    bgtop.maxFade = 1; bgtop.minFade = 0;bgtop.fadeSpeed = 0.2;bgtop.noLoop = true;
    bgbot.variation = fadeVariation;
    bgbot.maxFade = 1; bgbot.minFade = 0;bgbot.fadeSpeed = 0.2;bgbot.noLoop = true;
    bg.addAutomatism( "variation", { "type": "variation", "interval": 100 } )
    bgtop.addAutomatism( "variation", { "type": "variation", "interval": 0 } )
    bgbot.addAutomatism( "variation", { "type": "variation", "interval": 0 } )
    Game.scene.add( bg );
    Game.scene.add( bgtop );
    Game.scene.add( bgbot );
    Game.bgtop = bgtop; Game.bgbot = bgbot;
    
    // player one
    var pl1 = new DreamE.GameObject( { "name": "player1", "x": 80, "y": 360
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "player1", "scale": 1 } )
      , "collider": new DreamE.CircleCollider( { "radius": 45 } )
      , "zindex": 5
    } );
    pl1.color = "red";pl1.side = 1;
    pl1.checkInputs = checkInputs;
    pl1.fire = playerFire;
    pl1.index = 0;
    pl1.addAutomatism( "checkMove", { "type": "checkInputs" } );
    
    // player two
    var pl2 = new DreamE.GameObject( { "name": "player2", "x": 1200, "y": 360
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "player2", "scale": 1 } )
      , "collider": new DreamE.CircleCollider( { "radius": 45 } )
      , "zindex": 5
    } );
    pl2.color = "green";pl2.side = -1;
    pl2.checkInputs = checkInputs;
    pl2.fire = playerFire;
    pl2.index = 1;
    pl2.addAutomatism( "checkMove", { "type": "checkInputs" } );
    
    spawnBall();
    
    _score = new DreamE.GuiLabel( {
      'id': "counter", "fontSize": 60
      , 'x': screenW*0.5-100, 'y': 50, "w": 200, "h": 80
    }, "0 - 0" );
    
    var tactilP2 = new DreamE.GameObject( { "name": "Tactil Player2", "x": screenW-200, "y": pl2.position.y
      , "collider": new DreamE.FixedBoxCollider( { "width": 400, "height":screenH } )
      , "zindex": 4
    } );
    var tactilP1 = new DreamE.GameObject( { "name": "Tactil Player2", "x": 200, "y": pl1.position.y
      , "collider": new DreamE.FixedBoxCollider( { "width": 400, "height":screenH } )
      , "zindex": 4
    } );
    
    Game.p1Touch = false;
    Game.p2Touch = false;
    Game.targetP1 = 0;
    Game.targetP2 = 0;
    
    Game.camera.gui.add( _score );
    
    Game.scene.add( pl1 );
    Game.scene.add( pl2 );
    Game.scene.add( tactilP1 );
    Game.scene.add( tactilP2 );
    Game.tp1 = tactilP1;
    Game.tp2 = tactilP2;
    Game.p1 = pl1;
    Game.p2 = pl2;
    Game.p1.score = 0;
    Game.p2.score = 0;
    resetPowerPlayers();
    /*
    pl1.onMouseDown = function(mouse) 
    {
      pl1.fire();      
    }
    pl2.onMouseDown = function(mouse) 
    {
      pl2.fire();      
    }*/
    
    tactilP1.onMouseDown = function(mouse)
    {
      Game.p1Touch = true;      
    }
    tactilP2.onMouseDown = function(mouse)
    {
      Game.p2Touch = true;  
    }
    
    tactilP1.onMouseUp = function(mouse)
    {
      Game.p1Touch = false;
      DreamE.Inputs.keyUp({"keyCode":68});      
    }
    tactilP2.onMouseUp = function(mouse)
    {
      Game.p2Touch = false;  
      DreamE.Inputs.keyUp({"keyCode":37});
    }
    
    tactilP1.onMouseMove = function(mouse)
    {
      Game.targetP1 = mouse.y     
    }
    tactilP2.onMouseMove = function(mouse)
    {
      Game.targetP2 = mouse.y     
    }
    
    setTimeout( function(){ DreamE.States.down( "isLoading" ); }, 200 );
  };
  
  var bounceSpeed = 0.5;
  function ballOnFireCollision(bullet)
  {
    if (!bullet || !bullet.position)
      return;
    var vector = new DreamE.Vector2(0,0).getVector(bullet.position, this.position).normalize();
    this.gravity.x += vector.x * bounceSpeed * bullet.power;
    this.gravity.y += vector.y * bounceSpeed * bullet.power;
    
   bullet.askToKill()
  }
  
  function fadeVariation()
  {
    if ( !this.fading )
      return;
    var r = this.renderers[ 0 ];
    if ( this.fading == 1 )
    {
      r.alpha -= this.fadeSpeed;
      if ( r.alpha <= this.minFade )
      {
        if ( r.alpha < 0 )
          r.alpha = 0;
        this.fading = -1;
        if ( this.noLoop )
          this.fading = false;
      }
    }
    else if ( this.fading == -1 )
    {
      r.alpha += this.fadeSpeed;
      if ( r.alpha >= this.maxFade )
        this.fading = 1;
    }
  }
  
  var _playerRadius = 50;
  function spawnBall()
  {
    var ball = new DreamE.GameObject( { "tag": "ball", "x": screenW*0.5, "y": screenH*0.5
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "ball", "scale": 1 } )
      , "collider": new DreamE.CircleCollider( { "radius": _playerRadius*0.8>>0 } )
      , "zindex": 15
    } );
    ball.hurt = new DreamE.SpriteRenderer( { "spriteName": "ball_hurt", "scale": 1 } );
    ball.normal = ball.renderers[ 0 ];
    ball.hurt.gameObject = ball;
    ball.hurt.onAnimEnd = function()
    {
      this.restartAnim();
      this.gameObject.renderers[ 0 ] = this.gameObject.normal;
    }
    ball.gravity = { "x": 0, "y": 0 };
    ball.speed = 10;
    var customUpdate = ballCustomUpdate;
    ball.customUpdate = customUpdate;
    ball.onBulletCollision = ballOnFireCollision;
    ball.addAutomatism( "update", { "type": "customUpdate" } );
    Game.scene.add( ball );
  }
  
  function resetPowerPlayers()
  {
    Game.p1.power = 1 + powerSpeed;
    Game.p2.power = 1 + powerSpeed;
    Game.p1.updatePower = false;
    Game.p2.updatePower = false;
  }
  
  function resetBall( ball )
  {
    var objects = Game.scene.getGameObjects();
    for ( var i =0, bullet = null; bullet = objects[i]; ++i )
    {
      if ( bullet.tag == "fire" )
      {
        bullet.askToKill();
      }
    }
    resetPowerPlayers();
    ball.gravity = { "x": 0, "y": 0 };
    ball.speed = 10;
    ball.position = new DreamE.Vector2(screenW*0.5, screenH*0.5);

    ball.moved();
  }
  
  function ballCustomUpdate()
  {
    if ( _finalScore.endGame )
      return;
    var objects = Game.scene.getGameObjects();
    
    for ( var i =0, bullet = null; bullet = objects[i]; ++i )
    {
      if ( bullet.tag == "fire" && DreamE.CollisionSystem.circleCollision(bullet.collider, this.collider) )
      {
        this.onBulletCollision(bullet);
      }
    }
    
    this.nextMove = { "x": this.gravity.x * this.speed
      , "y": this.gravity.y * this.speed
    };
    
    this.translate( this.nextMove );
    
    // after moving
    if ( this.position.y < 100 )
    {
      this.position.y = 100;
      this.gravity.y = -this.gravity.y;
      Game.bgtop.fading = -1;
      this.renderers[ 0 ] = this.hurt;
    }
    if ( this.position.y > screenH - 100 )
    {
      this.position.y = screenH - 100;
      this.gravity.y = -this.gravity.y;
      Game.bgbot.fading = -1;
      this.renderers[ 0 ] = this.hurt;
    }
    if ( this.position.x < 0 )
    {
      // player 1 lose
      if ( changeScore( false, true ) )
        resetBall( this );
    }
    else if ( this.position.x > screenW )
    {
      // player 2 lose
      if ( changeScore( true, false ) )
        resetBall( this );
    } 
  }
  
  function changeScore( p1, p2 )
  {
    if ( _finalScore.ended )
      return;
    Game.p1.score += ( p1 ) ? 1 : 0;
    Game.p2.score += ( p2 ) ? 1 : 0;
    _score.setText( Game.p1.score + " - " + Game.p2.score );
    
    if ( Game.p1.score >= 3 || Game.p2.score >= 3 )
    {
      endGame( ( Game.p1.score > Game.p2.score ) ? 1 : 2 );
      return false;
    }
    return true;
  }
  
  function endGame( pWinner )
  {
    _finalScore.endGame = true;
    // _finalScore[ pWinner ].renderers[ 0 ].restartAnim();
    // _finalScore[ pWinner ].disable = false;
    setTimeout( function(){ resetGame(); }, 800 );
  }
  
  function resetGame()
  {
    Game.p1.position.y = screenH * 0.5;
    Game.p2.position.y = screenH * 0.5;
    Game.p1.score = 0;
    Game.p2.score = 0;
    resetPowerPlayers();
    _score.setText( "0 - 0" );
    
    var objects = Game.scene.getGameObjects();
    for ( var i = 0, o; i < objects.length; ++i )
    {
      o = objects[ i ];
      if ( o.tag == "fire" || o.tag == "ball" )
        o.askToKill();
    }
    spawnBall();
    _finalScore.endGame = false;
  }
  
  var maxPower = 7;
  var powerSpeed = 0.03;
  function checkInputs()
  {
    var gamepad = GamePad.gamePadsInfos[ this.index ];
    var axeV = 0;
    if ( gamepad )
    {
      axeV = gamepad.axes[ 1 ];
      axeV = ( Math.abs( axeV ) > 0.3 ) ? axeV : 0;
    }
    if ( DreamE.Inputs.key( "j" + (this.index + 1) + "top" ) )
      axeV = -1;
    else if ( DreamE.Inputs.key( "j" + (this.index + 1) + "bot" ) )
      axeV = 1;
    
    this.translateY( axeV * 10 );
    
    if ( this.position.y < _playerRadius )
      this.position.y = _playerRadius;
    if ( this.position.y > screenH - _playerRadius )
      this.position.y = screenH - _playerRadius;
    
    
    if (this.power < maxPower && this.updatePower)
    {
      this.power += powerSpeed * DreamE.Time.deltaTime;
    }
      
    if ( DreamE.Inputs.key( "j" + (this.index + 1) + "fire" ) )
      this.fire();
    
  }
  
  function playerFire()
  {
    
    // this.position
    var fire = new DreamE.GameObject( { "name": "fire", "tag": "fire", "zindex": 10
      , "x": this.position.x, "y": this.position.y
      , "renderer": new DreamE.SpriteRenderer( { "spriteName": "fire" + this.side, "scale": 1 * this.power } )
      , "collider": new DreamE.CircleCollider( { "radius": 20 * this.power } )
    } );
    fire.side = this.side;
    fire.speed = 10;
    fire.power = this.power;
    fire.moveMe = autoMove;
    fire.addAutomatism( "move", { "type": "moveMe" } );
    Game.scene.add( fire );
    
    this.power = 1 - powerSpeed;
    this.updatePower = true;
  }
  
  function autoMove()
  {
    this.translateX( this.side * this.speed );
    
    if ( this.position.x < -50 || this.position.x > screenW + 50
      || this.position.y < -50 || this.position.y > screenH + 50 )
    {
      this.askToKill();
    }
  }
  window.Game = Game; // debug
  return Game;
} );