﻿/**
* @ContributorsList
* @Inateno / http://inateno.com / http://dreamirl.com
*
***
* @constructor
* MainLoop
**/

define( [ 'DE.Time', 'DE.CONFIG', 'DE.States', "DE.Inputs", "DE.GamePad", "DE.SystemDetection" ],
function( Time, CONFIG, States, Inputs, GamePad, SystemDetection )
{
  var MainLoop = new function()
  {
    this.DEName = "MainLoop";
    this.launched = false;
    
    this.renders = new Array();
    this.scenes = new Array();
    
    this.maxRenders = 1;
    this.loader = null;
    /***
    * @loop
    ***/
    this.loop = function()
    {
      if ( !MainLoop.launched )
      {
        return;
      }
      requestAnimationFrame( MainLoop.loop );
      
      if ( !Time.update() ){ return; }
      
      if ( States.get( "isLoading" ) )
      {
        if ( !MainLoop.loader )
          return;
        for ( var i = 0, j; j = MainLoop.renders[ i ]; i++ )
        {
          j.ctx.translate( j.sizes.width * 0.5, j.sizes.height * 0.5 );
          MainLoop.loader.render( j.ctx, 1 );
          j.ctx.translate( -j.sizes.width * 0.5, -j.sizes.height * 0.5 );
        }
        return;
      }
      else if ( SystemDetection.isOverridingMainLoop )
      {
        if ( !SystemDetection.render )
          return;
        
        SystemDetection.render.render();
        SystemDetection.scene.update( Time.currentTime );
      }
      else if ( States.get( 'isReady' ) )
      {
        GamePad.update( Time.currentTime );
        for ( var i = 0, j; j = MainLoop.renders[ i ]; i++ )
        {
          j.render();
          //j.update(); // call waiting input here
        }
        MainLoop.customLoop( Time.currentTime );
       
        for ( var i = 0, j; j = MainLoop.scenes[ i ]; i++ )
        {
          if ( !j.freeze && !j.sleep )
          {
            j.update();
          }
        }
      }
    };
    
    /***
    * @addRender
    ***/
    this.addRender = function( render )
    {
      render.id = this.maxRenders++;
      this.renders.push( render );
    };
    
    /***
    * @addScene
    ***/
    this.addScene = function( scene )
    {
      this.scenes.push( scene );
    }
    
    /***
    * @customLoop
    need to override in customs files
    ***/
    this.customLoop = function( time ){}
  };
  
  if ( CONFIG.DEBUG && CONFIG.DEBUG_LEVEL >= 3 )
  {
    console.log( "MainLoop loaded" );
  }
  return MainLoop;
} );