﻿function Place() {
  this.base = 10;
  this.checkinDate = "";
  this.city = "";
  this.conqueror = "";
  this.lat = 54.3;
  this.lng = 4.9;
  this.men = 10;
  this.photoUrl;
  this.googlePlaceResult = false;
  this.notificationSubscribed = true;
  this.placeResult;
  this.points = "--";
  this.pointsBreakdown = new Array();
  this.pozcardDescription = "";
  this.website = "";
  this.women = 10;
}

Place.prototype.getCheckinDate = function () {
  return this.checkinDate;
};

Place.prototype.setCheckinDate = function (checkinDate) {
  this.checkinDate = checkinDate;
};

Place.prototype.getCity = function () {
  return this.city;
};

Place.prototype.setCity = function (city) {
  this.city = city;
};

Place.prototype.getConqueror = function () {
  return this.conqueror;
};

Place.prototype.setConqueror = function (conqueror) {
  this.conqueror = conqueror;
};

Place.prototype.getLat = function () {
  return this.lat;
};

Place.prototype.setLat = function (lat) {
  this.lat = lat;
};

Place.prototype.getLng = function () {
  return this.lng;
};

Place.prototype.setLng = function (lng) {
  this.lng = lng;
};

Place.prototype.getMen = function () {
  return this.men;
};

Place.prototype.setMen = function (men) {
  this.men = (men + this.base);
};

Place.prototype.loadPoints = function () {
  consoleLog("loadPoints: " + this.getPlaceResult.name);
  $(GLOBAL).trigger('loadPoints');
  var obj = this;

  ajaxCall("/api/v1/getPoints.php", {
    uuid: localStorage["uniqueId"],
    name: this.placeResult.name,
    vicinity: this.placeResult.vicinity,
    city: this.city,
    website: this.website,
    lat: this.lat,
    lng: this.lng,
    ulat: defaultLatLng.lat(),
    ulng: defaultLatLng.lng()
  }).fail(function (data) {
    consoleLog("getPoints error: " + JSON.stringify(data));
  }).done(function (data) {
    if (data.response != undefined) {
      switch (data.response.responseCode) {
        case 200:
          if (data.response.value != undefined) {
            for (var key in data.response.value) {
              if (!data.response.value.hasOwnProperty(key)) {
                //The current property is not a direct property of p
                continue;
              }
              switch (key) {
                case "points":
                  /**
                   * Translate the points to human readable points.
                   */
                  var breakDown = "";
                  for (var keyPoint in data.response.value[key]) {
                    switch (keyPoint) {
                      case "totalPoints":
                        obj.setPoints(data.response.value[key][keyPoint]);
                        $(".points" + obj.placeResult.id).html(obj.getPoints());
                        break;
                      default:
                        if (data.response.value[key][keyPoint]["points"] != null && data.response.value[key][keyPoint]["points"] > 0) {
                          obj.addPointsBreakDown(data.response.value[key][keyPoint]["name"], data.response.value[key][keyPoint]["points"]);
                          breakDown += data.response.value[key][keyPoint]["name"] + " = " + data.response.value[key][keyPoint]["points"] + "<br/>";
                        }
                        if (data.response.value[key][keyPoint]["percentage"] != null && data.response.value[key][keyPoint]["percentage"] > 0) {
                          obj.addPointsBreakDown(data.response.value[key][keyPoint]["name"] + " %", data.response.value[key][keyPoint]["percentage"]);
                          breakDown += data.response.value[key][keyPoint]["name"] + " % = " + data.response.value[key][keyPoint]["percentage"] + "<br/>";
                        }
                        break;
                    }
                  }
                  if ($("#addPointsToPlacePointsTotal").val() > 10 && localStorage["loginToken"] != null) {
                    var name = obj.placeResult.name;
                    if (obj.placeResult.name != null) {
                      name = obj.placeResult.name.replace(/'/g, "\\'").replace(/"/g, "\&quot;");
                    }
                    var vicinity = obj.placeResult.vicinity;
                    if (obj.placeResult.vicinity != null) {
                      vicinity = obj.placeResult.vicinity.replace(/'/g, "\\'").replace(/"/g, "\&quot;");
                    }
                    var city = obj.city;
                    if (obj.placeResult.city != null) {
                      city = obj.placeResult.city.replace(/'/g, "\\'").replace(/"/g, "\&quot;");
                    }
                    var website = obj.website;
                    if (obj.placeResult.website != null) {
                      website = obj.placeResult.website.replace(/'/g, "\\'").replace(/"/g, "\&quot;");
                    }
                    breakDown += '<a class="tiny button" onClick="addPointsToPlaceModal(\'' + obj.placeResult.id + '\', \'' + name + '\', \'' + vicinity + '\', \'' + city + '\', \'' + website + '\', \'' + obj.lat + '\', \'' + obj.lng + '\');">' + $("#i18AddPointsLabel").html() + '</a>';
                  }
                  $(".pointsBreakdown" + obj.placeResult.id).html(breakDown);
                  break;
                case "gender":
                  if (data.response.value.gender.men != null && parseInt(data.response.value.gender.men) != 0) {
                    obj.setMen(parseInt(data.response.value.gender.men));
                  }
                  if (data.response.value.gender.women != null && parseInt(data.response.value.gender.women) != 0) {
                    obj.setWomen(parseInt(data.response.value.gender.women));
                  }
                  var total = obj.men + obj.women;
                  var pMen = obj.getPercentage(obj.men, total);
                  var pWomen = obj.getPercentage(obj.women, total);
                  $(".men" + obj.placeResult.id).css("width", pMen + "%");
                  $(".women" + obj.placeResult.id).css("width", pWomen + "%");
                  $(".men" + obj.placeResult.id).html("<div class='placeGenderPercentageLabel'>" + parseFloat(pMen).toFixed(1) + "%</div>");
                  $(".women" + obj.placeResult.id).html("<div class='placeGenderPercentageLabel'>" + parseFloat(pWomen).toFixed(1) + "%</div>");
                  var icon = "img/trans.png";
                  if (pMen > pWomen) {
                    icon = "img/mars.png";
                  } else if (pMen < pWomen) {
                    icon = "img/venus.png";
                  }
                  $(".genderIcon" + obj.placeResult.id).attr("src", icon);
                  markersObjArray[obj.placeResult.id].setIcon(icon);
                  break;
                case "conqueror":
                  obj.setConqueror(data.response.value.conqueror.nickname);
                  obj.setPhotoUrl(data.response.value.conqueror.photoUrl);
                  var html = "";
                  if (obj.conqueror != null && obj.conqueror.length > 0) {
                    if (html.length == 0) {
                      html += $("#i18ConqueredByLabel").html();
                    }
                    html += obj.conqueror;
                    if (obj.photoUrl != null && obj.photoUrl.length > 0) {
                      html += " <img class='conquerorImage' alt='" + obj.conqueror + "' src='" + obj.photoUrl + "'></img>";
                    }
                  } else if (obj.photoUrl != null && obj.photoUrl.length > 0) {
                    if (html.length == 0) {
                      html += $("#i18ConqueredByLabel").html();
                    }
                    html += " <img class='conquerorImage' alt='" + obj.conqueror + "' src='" + obj.photoUrl + "'></img>";
                  }
                  $(".conqueror" + obj.placeResult.id).html(html);
                  break;
                case "notificationSubscribed":
                  consoleLog(JSON.stringify(data.response.value));
                  obj.setIsNotificationSubscribed(data.response.value.notificationSubscribed);
                  $("#notificationSubscribe" + obj.placeResult.id).prop("checked", obj.isNotificationSubscribed());
                  break;
              }
            }
          } else {
            consoleLog("getPoints no points: " + data.response.responseCode + ":" + data.response.message);
          }
          break;
        case 401:
          consoleLog(JSON.stringify(data));
          break;
        case 404:
        case 412:
          revealMessageDialog("getPoints authentication error", data.response.responseCode + ": " + data.response.message);
          localStorage.clear();
          break;
        default:
          revealMessageDialog("getPoints error ", data.response.responseCode + ": " + data.response.message);
          localStorage.clear();
          break;
      }
    } else {
      revealMessageDialog("getPoints server error", data);
      localStorage.clear();
    }
  }).always(function () {
    consoleLog("loadPointsDone fired");
    $(GLOBAL).trigger('loadPointsDone');
  });
}

Place.prototype.getPhotoUrl = function () {
  return this.photoUrl;
};

Place.prototype.setPhotoUrl = function (photoUrl) {
  this.photoUrl = photoUrl;
};

Place.prototype.getPoints = function () {
  return this.points;
};

Place.prototype.setPoints = function (points) {
  this.points = points;
};

Place.prototype.addPointsBreakDown = function (name, points) {
  this.pointsBreakdown[name] = points;
};

Place.prototype.clearPointsBreakDown = function () {
  this.pointsBreakdown = new Array();
};

Place.prototype.getPointsBreakdown = function () {
  return this.pointsBreakdown;
};

Place.prototype.removePointsBreakDown = function (name) {
  delete this.pointsBreakdown[name];
};

Place.prototype.setPointsBreakDown = function (pointsBreakdown) {
  this.pointsBreakdown = pointsBreakdown;
};

Place.prototype.getWomen = function () {
  return this.women;
};

Place.prototype.setWomen = function (women) {
  this.women = (women + this.base);
};

Place.prototype.getWebsite = function () {
  return this.website;
};

Place.prototype.setWebsite = function (website) {
  this.website = website;
};

Place.prototype.isGooglePlaceResult = function () {
  return this.googlePlaceResult;
};

Place.prototype.setIsGooglePlaceResult = function (googlePlaceResult) {
  this.googlePlaceResult = googlePlaceResult;
};

Place.prototype.isNotificationSubscribed = function () {
  return this.notificationSubscribed;
};

Place.prototype.setIsNotificationSubscribed = function (notificationSubscribed) {
  this.notificationSubscribed = notificationSubscribed;
};

Place.prototype.getPlaceResult = function () {
  return this.placeResult;
};

Place.prototype.setPlaceResult = function (placeResult) {
  this.placeResult = placeResult;
};

Place.prototype.getPercentage = function (fraction, total) {
  return (fraction / total * 100);
};

Place.prototype.getPozcardDescription = function () {
  return this.pozcardDescription;
};

Place.prototype.setPozcardDescription = function (pozcardDescription) {
  this.pozcardDescription = pozcardDescription;
};

Place.prototype.getDistance = function (defaultLatLng) {
  return getDistance(defaultLatLng.lat(), defaultLatLng.lng(), this.lat, this.lng);
};

Place.prototype.titleClick = function () {
  map.setCenter(new google.maps.LatLng(this.lat, this.lng));
  $(".title" + this.placeResult.id).next().slideToggle().prev().find('.arrow').toggleClass('arrow-up arrow-down');
  if (this.isGooglePlaceResult()) {
    getPlaceDetails(this.placeResult);
  } else {
    this.loadPoints();
  }
}

Place.prototype.getHtmlPricingTable = function (show) {
  var html = '';
  if (this.placeResult != null) {
    if (show) {
      this.loadPoints();
    }
    var distance = this.getDistance(defaultLatLng).toFixed(1);
    var icon = "img/trans.png";

    var percentage = this.getPercentage(this.men, this.men + this.women);
    if (parseFloat(percentage) > 50) {
      icon = "img/mars.png";
    } else if (parseFloat(percentage) < 50) {
      icon = "img/venus.png";
    }
    markersObjArray[this.placeResult.id].setIcon(icon);

    html += '<ul class="pricing-table place">';
    if (show) {
      html += '<li class="title">' + this.placeResult.name + ' - ' + distance + 'km' + '</li>';
    } else {
      html += '<li class="title pointer title' + this.placeResult.id + '" onClick="placesObjArray[\'' + this.placeResult.id + '\'].titleClick();"><img class="genderIcon' + this.placeResult.id + '" src="' + icon + '"/> ' + this.placeResult.name + ' - ' + distance + 'km' + '<div class="arrow arrow-up right"></div></li>';
    }
    html += '<div class="' + ((show) ? "" : "hide") + '">';
    html += '<li class="price pointer" onClick="$(\'.pointsBreakdown' + this.placeResult.id + '\').toggle(\'hide\');"><span class="points' + this.placeResult.id + '">' + this.points + '</span> ' + $("#i18PointsLabel").html().toLowerCase() + ' <small>[+]</small></li>';
    html += '<li class="description hide pointsBreakdown' + this.placeResult.id  + '">No bonus points</li>';
    html += '<li class="description">' + this.placeResult.vicinity + '</li>';
    html += '<li class="bullet-item"><div class="progress round"><div class="meter left men men' + this.placeResult.id + '" style="width: ' + percentage + '%;"><div class="placeGenderPercentageLabel">' + percentage + '%</div></div><div class="meter women right women' + this.placeResult.id + '" style="width: ' + (100 - percentage) + '%;"><div class="placeGenderPercentageLabel">' + (100 - percentage) + '%</div></div></div></li>';
    //html += '<li class="bullet-item">Lat: ' + this.placeResult.geometry.location.lat() + ', Lng: ' + this.placeResult.geometry.location.lng() + '</li>';
    html += '<li class="bullet-item conqueror' + this.placeResult.id + '"></li>';
    html += '<li class="cta-button">';
    html += '<a class="conquerButton button tiny" href="javascript: void(0);" onClick="checkIn(placesObjArray[\'' + this.placeResult.id + '\']);">' + $("#i18ConquerLabel").html() + '</a>';
    html += ' <a class="button secondary tiny challengeButton hide-for-app" href="javascript: void(0);" onClick="challenge(placesObjArray[\'' + this.placeResult.id + '\']);">' + $("#i18ChallengeLabel").html() + ' [+]</a>';
    html += ' <a class="button secondary tiny assembleButton" href="javascript: void(0);" onClick="assemble(placesObjArray[\'' + this.placeResult.id + '\']);">' + $("#i18AssembleLabel").html() + '</a>';
    html += ' <a class="button secondary tiny show-for-app" onClick="window.plugins.socialsharing.share(null, \'' + this.placeResult.name.replace(/'/g, "\\'").replace(/"/g, "\&quot;") + '\', \'http://www.pozzy.nl/img/socialDefault.jpg\', \'https://www.pozzy.eu\');">Share</a>';
    html += ' <label class="show-for-app"><input type="checkbox" id="notificationSubscribe' + this.placeResult.id + '" onClick="notificationSubscribe(placesObjArray[\'' + this.placeResult.id + '\'], this.checked);" /> Notifications</label>';
    html += '</li>';
    html += '</div>';
    html += '</ul>';
  }
  return html;
}
