﻿
/**
 * Show notifications count in menu.
 */
function showNotificationsCount() {
  consoleLog("showNotificationsCount fired");
  $(GLOBAL).trigger("showNotificationsCount");
  ajaxCall("/api/v1/getNotificationsCount.php", {
    uuid: localStorage["uniqueId"]
  }).fail(function (data) {
    consoleLog("showNotificationsCount error: " + JSON.stringify(data));
  }).done(function (data) {
    if (data.response != undefined) {
      if (data.response.responseCode == 200) {
        var notificationsCount = data.response.value.notifications.count;
        var notificationsUnread = (data.response.value.notifications.unread > 0) ? data.response.value.notifications.unread : '';
        consoleLog("Notifications count: " + notificationsCount);
        consoleLog("Notifications unread: " + notificationsUnread);
        if (notificationsCount > 0) {
          $(".notificationsCount").html(notificationsUnread);
          $(".notificationsMenu").show();
        } else {
          $(".notificationsMenu").hide();
        }
      } else {
        consoleLog("showNotificationsCount responsCode error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
      }
    } else {
      consoleLog("showNotificationsCount error unexpected response: " + data);
    }
  }).always(function () {
    // Trigger done event.
    consoleLog("showNotificationsCountDone fired");
    $(GLOBAL).trigger("showNotificationsCountDone");
  });
}

/**
 * Show notifications.
 */
function getNotifications() {
  consoleLog("getNotifications fired");
  $(GLOBAL).trigger("getNotifications");
  $("#notificationsHtml").html("<img src='img/smallLoader.gif'/>");

  ajaxCall("/api/v1/getNotifications.php", {
    uuid: localStorage["uniqueId"]
  }).fail(function (data) {
    consoleLog("getNotifications error: " + JSON.stringify(data));
  }).done(function (data) {
    if (data.response != undefined) {
      if (data.response.responseCode == 200) {
        var html = '';
        for (var key in data.response.value.notifications) {
          var seen = data.response.value.notifications[key]["seen"];
          html += '<hr/><span>';
          if (seen == "0") {
            html += '<b>';
          }
          html += data.response.value.notifications[key]["message"];
          if (seen == "0") {
            html += '</b>';
          }
          html += '</span><a href="javascript: void(0);" class="cross right" onClick="removeNotification(' + data.response.value.notifications[key]["id"] + ');">&#215;</a>';
          html += '<div class="lightGrey"><small>';
          html += data.response.value.notifications[key]["notify_date"];
          html += '</small></div>';
        }
        $("#notificationsHtml").html(html);
      } else {
        consoleLog("getNotifications responsCode error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
      }
    } else {
      consoleLog("getNotifications error unexpected response: " + data);
    }
  }).always(function () {
    // Trigger done event.
    consoleLog("getNotificationsDone fired");
    $(GLOBAL).trigger("getNotificationsDone");
    showNotificationsCount();
  });
}

/**
 * Remove notification.
 */
function removeNotification(id) {
  consoleLog("removeNotification");
  $(GLOBAL).trigger("removeNotification");
  ajaxCall("/api/v1/removeNotification.php", {
    uuid: localStorage["uniqueId"],
    id: id
  }).fail(function (data) {
    consoleLog("removeNotification error: " + JSON.stringify(data));
  }).done(function (data) {
    if (data.response != undefined) {
      if (data.response.responseCode == 200) {
        showNotificationsCount();
        getNotifications();
      } else {
        consoleLog("removeNotification responsCode error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
      }
    } else {
      consoleLog("removeNotification error unexpected response: " + data);
    }
  }).always(function () {
    // Trigger done event.
    consoleLog("removeNotificationDone fired");
    $(GLOBAL).trigger("removeNotificationDone");
  });
}

/**
 * Set notification subscription.
 */
function notificationSubscribe(obj, value) {
  consoleLog("notificationSubscribe");
  $(GLOBAL).trigger("notificationSubscribe");
  ajaxCall("/api/v1/setNotification.php", {
    uuid: localStorage["uniqueId"],
    name: obj.getPlaceResult().name,
    vicinity: obj.getPlaceResult().vicinity,
    lat: obj.getLat(),
    lng: obj.getLng(),
    active: value
  }).fail(function (data) {
    consoleLog("notificationSubscribe error: " + JSON.stringify(data));
  }).done(function (data) {
    if (data.response != undefined) {
      if (data.response.responseCode == 200) {
        $(GLOBAL).trigger("saveSettingsToServerDone");
      } else {
        consoleLog("notificationSubscribe responsCode error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
      }
    } else {
      consoleLog("notificationSubscribe error unexpected response: " + data);
    }
  }).always(function () {
    // Trigger done event.
    consoleLog("notificationSubscribeDone fired");
    $(GLOBAL).trigger("notificationSubscribeDone");
  });
}