﻿function addPointsToPlaceModal(id, name, vicinity, city, website, lat, lng) {
  $("#addPointsToPlaceId").val(id);
  $("#addPointsToPlaceName").val(name);
  $("#addPointsToPlaceVicinity").val(vicinity);
  $("#addPointsToPlaceCity").val(city);
  $("#addPointsToPlaceWebsite").val(website);
  $("#addPointsToPlaceLat").val(lat);
  $("#addPointsToPlaceLng").val(lng);
  $("#addPointsToPlaceTitle").html(name + ", " + vicinity);
  revealDialog("#addPointsToPlaceModal");
}

function addPointsToPlace() {
  consoleLog("Add points to place: " + $("#addPointsToPlaceName").val() + " " + $("#addPointsToPlaceVicinity").val() + " " + $("#addPointsToPlaceCity").val() + " " + $("#addPointsToPlaceWebsite").val() + " " + $("#addPointsToPlaceLat").val() + " " + $("#addPointsToPlaceLng").val() + " " + $("#addPointsToPlacePointsTotal").val());
  consoleLog("addPointsToPlace fired");
  $(GLOBAL).trigger("addPointsToPlace");

  ajaxCall("/api/v1/addPointsToPlace.php", {
    uuid: localStorage["uniqueId"],
    token: localStorage["loginToken"],
    name: $("#addPointsToPlaceName").val(),
    vicinity: $("#addPointsToPlaceVicinity").val(),
    city: $("#addPointsToPlaceCity").val(),
    website: $("#addPointsToPlaceWebsite").val(),
    lat: $("#addPointsToPlaceLat").val(),
    lng: $("#addPointsToPlaceLng").val(),
    points: $("#addPointsToPlacePoints").val()
  }).fail(function (data) {
    revealMessageDialog("Points not added", "Points could not be added. This could be caused by one of the following reasons:<br/>- Can only add once per place per day<br/>- Not enough points");
  }).done(function (data) {
    if (data.response != undefined) {
      if (data.response.responseCode == 200) {
        if (data.response.value != undefined) {
          consoleLog("addPointsToPlace value: " + data.response.message);
          revealMessageDialog(data.response.message, data.response.value);
          placesObjArray[$("#addPointsToPlaceId").val()].loadPoints();
          getPointsTotal();
        } else {
          consoleLog("addPointsToPlace value error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
          revealMessageDialog("Points not added", "Points could not be added. This could be caused by one of the following reasons:<br/>- Can only add once per place per day<br/>- Not enough points");
        }
      } else {
        consoleLog("addPointsToPlace responsCode error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
        revealMessageDialog("Points not added", "Points could not be added. This could be caused by one of the following reasons:<br/>- Can only add once per place per day<br/>- Not enough points");
      }
    } else {
      consoleLog("addPointsToPlace error unexpected response: " + data);
      revealMessageDialog("Points not added", "Points could not be added. This could be caused by one of the following reasons:<br/>- Can only add once per place per day<br/>- Not enough points");
    }
  }).always(function () {
    consoleLog("addPointsToPlaceDone fired");
    $(GLOBAL).trigger("addPointsToPlaceDone");
  });
}

function getPointsTotal() {
  consoleLog("getPointsTotal called");
  $(GLOBAL).trigger("getPointsTotal");

  ajaxCall("/api/v1/getPointsTotal.php", {
    uuid: localStorage["uniqueId"]
  }).fail(function (data) {
    consoleLog("getPointsTotal error: " + JSON.stringify(data));
  }).done(function (data) {
    if (data.response != undefined) {
      if (data.response.responseCode == 200) {
        if (data.response.value != undefined) {
          $(".pointsTotal").html(parseFloat(data.response.value.points).toFixed() + "pts");
          $(".pointsTotal").val(parseFloat(data.response.value.points).toFixed());
        } else {
          consoleLog("getPointsTotal value error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
        }
      } else {
        consoleLog("getPointsTotal responsCode error: " + data.response.responseCode + ":" + data.response.message + " : " + data);
      }
    } else {
      consoleLog("getPointsTotal error unexpected response: " + data);
    }
  }).always(function () {
    consoleLog("getPointsTotalDone fired");
    $(GLOBAL).trigger("getPointsTotalDone");
  });
}