﻿$(GLOBAL).bind("zoomDone", function () {
  consoleLog("zoomDone event captured");
  showMarkerPersonalMessage();
  google.maps.event.trigger(map, 'resize');
});

var pozcards = [];

google.maps.event.addDomListener(window, 'load', initialize);
var defaultLatLng = new google.maps.LatLng(52.13, 5.18);
var bounds = new google.maps.LatLngBounds();
//var infowindow = new google.maps.InfoWindow();

function initialize() {
  var mapOptions = {
    center: defaultLatLng,
    zoom: zoom,
    scrollwheel: false,
    disableDoubleClickZoom: true,
    zoomControl: false,
    draggable: false,
    streetViewControl: false,
    panControl: false,
    mapTypeControl: false
  };
  map = new google.maps.Map(document.getElementById("map-canvas"), mapOptions);

  google.maps.event.addListener(map, 'zoom_changed', function () {
    if (initialZoom) {
      var zoomLevel = map.getZoom();
      consoleLog('Zoom: ' + zoomLevel);
      if (zoom > zoomLevel) {
        setTimeout(zoomMap, 500);
      } else {
        $(GLOBAL).trigger('zoomDone');
        initialZoom = false;
      }
    }
  });
  getTravels(getUrlVars()["pozcard"]); 
}

function clearPozcard() {
  $('#pozcardFields').hide();
  $('#pozcardTravelLogs').html('');
  removeLines();
  deleteMarkers();
  deletePlaces();
}

/**
 * Retrieve checkins.
 */
function getTravels(uniqid) {
  consoleLog("getTravels");
  $(GLOBAL).trigger('getTravels');
  clearPozcard();

  ajaxCall("/api/v1/getPozcard.php", {
    uuid: localStorage["uniqueId"],
    uniqid: uniqid
  }).fail(function(data){
    consoleLog("getPozcard error: " + JSON.stringify(data));
  }).done(function(data){
    if (data.response != null) {
      switch (data.response.responseCode) {
        case 200:
          var empty = true;
          for (var key in data.response.value.places) {
            empty = false;
            createPozcardMarker(data.response.value.places[key]);
          }
          pozcardNickname = data.response.value.nickname;
          $("#pozcardTitle").text(data.response.value.title);
          var description = $("<div/>").text(data.response.value.description).html();
          $("#pozcardDescription").html(description.replace(/\n/g, '<br />'));
          $("#startDate").text(data.response.value.startDate);
          $("#endDate").text(data.response.value.endDate);
          var url = window.location.protocol + "//" + window.location.hostname + "/pozcard.php?pozcard=" + data.response.value.uniqid;
          $("#pozcardUrl").val(url);
          $("#fb-pozcard").attr("data-href", url);
          $("#tw-pozcard").attr("data-url", url);
          $("#socialLinks").show();
          if (typeof (fbStart) != "undefined") fbStart();
          if (typeof (twitterStart) != "undefined") twitterStart();
          if (typeof (gplusStart) != "undefined") gplusStart();
          break;
        default:
          break;
      }
    }
  }).always(function(){
    // Trigger event.
    consoleLog("getTravelsDone fired");
    $(GLOBAL).trigger('getTravelsDone');
  });
}
