﻿var lastSearchFunction = searchPlaces;

$("input:radio[name ='interestMen']").change(function () {
  lastSearchFunction();
})

$("input:radio[name ='interestWomen']").change(function () {
  lastSearchFunction();
})

$("input:radio[name ='interestMe']").change(function () {
  lastSearchFunction();
})

$(GLOBAL).bind("requestNearbyPlaces", function () {
  consoleLog("requestNearbyPlaces event captured");
  $(".searchButton").html("<img src='img/smallLoader.gif'/>");
});

$(GLOBAL).bind("processNearbyPlacesDone", function () {
  consoleLog("processNearbyPlacesDone event captured");
  $(".searchButton").html($("#i18SearchButtonLabel").html());
});

$(GLOBAL).bind("getNearbyHottestPlacesDone", function () {
  consoleLog("getNearbyHottestPlacesDone event captured");
  $(".hottestPlacesButton").html("Hot");
});

$(GLOBAL).bind("getNearbyPointsDone", function () {
  consoleLog("getNearbyPointsDone event captured");
  $(".placesByPointsButton").html($("#i18PointsButtonLabel").html());
});

$(GLOBAL).bind("getNearbyConqueredPlacesDone", function () {
  consoleLog("getNearbyConqueredPlacesDone event captured");
  $(".nearbyPlacesButton").html("Reset");
});

function getHottestPlaces() {
  $(".hottestPlacesButton").html("<img src='img/smallLoader.gif'/>");
  getNearbyPlaces('getNearbyHottestPlaces', $('#searchRadius').val(), true);
  lastSearchFunction = getHottestPlaces;
}

function getPlacesByPoints() {
  $(".placesByPointsButton").html("<img src='img/smallLoader.gif'/>");
  getNearbyPlaces('getNearbyPoints', $('#searchRadius').val(), true);
  lastSearchFunction = getPlacesByPoints;
}

function getNearbyConqueredPlaces() {
  $(".nearbyPlacesButton").html("<img src='img/smallLoader.gif'/>");
  getNearbyPlaces('getNearbyConqueredPlaces', $('#searchRadius').val());
  lastSearchFunction = getNearbyConqueredPlaces;
}

function getChallenges() {
  getNearbyPlaces("getChallenges", $('#searchRadius').val(), true, processChallenges);
  lastSearchFunction = getNearbyConqueredPlaces;
}

/**
 * Search places based on given keyword.
 * The results are placed as markers on the map.
 */
function searchPlaces() {
  consoleLog("searchPlaces");
  var keyword = $('#venue').val();
  var theRadius = "5000000";
  if (localStorage["#searchRadius"] != null && localStorage["#searchRadius"] > 0) {
    theRadius = localStorage["#searchRadius"];
  }
  if ($('#searchRadius').length > 0) {
    theRadius = $('#searchRadius').val();
  }
  $("#places").html("No results");

  if (theRadius != "20000000") {
    radius = theRadius;
    requestNearbyPlaces(keyword, defaultLatLng, true);
  } else {
    getLatLong(keyword, requestNearbyPlaces);
  }
  lastSearchFunction = searchPlaces;
}

function searchPlace() {
  consoleLog("searchPlace");
  $("#places").html("No results");

  radius = "20000000";
  requestNearbyPlaces($('#venue').val(), defaultLatLng, true);
  lastSearchFunction = searchPlace;
}

function processChallenges(data) {
  if (data.response.value != undefined) {
    consoleLog("processChallenges: " + JSON.stringify(data.response));
    processPlaces(data.response.value);
    createPlacesResultList();
    revealDialog(challengedByModal);
  } else {
    consoleLog(apiCall + " no places: " + data.response.responseCode + ":" + data.response.message);
  }
}
