(function app() {
	'use strict';

	function ready() {
		// Are we there yet?
		if (!navigator.onLine) {
			return;
		}

		// "Replace" history to prevent back navigation
		var url = 'http://ffmtn.pricecheck.co.za/';
		location.replace(url);
	}

	// Called on start and on every offline/online event
	function onlineCheck() {
		if (navigator.onLine) {
			document.documentElement.classList.remove('is-offline');
			ready();
		} else {
			document.documentElement.classList.add('is-offline');
		}
	}

	// Called on load to ensure splashscreen shows up
	window.addEventListener('load', function() {
		window.addEventListener('online', onlineCheck);
		window.addEventListener('offline', onlineCheck);
		onlineCheck();
	});

})();