/*
* @Prometeus Technology, a subsidiary of Pegasus Tech Supply
* @copyright Copyright (C)2014 Leonardo Tadei. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see gpl-3.0.txt
* priceComparator is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.


Comparar precios entre los valores cargados
*/
function comparar(){
	limpiarResultados();
	
	can1 = parseFloat(document.getElementById('can1').value);
	can2 = parseFloat(document.getElementById('can2').value);
	can3 = parseFloat(document.getElementById('can3').value);
	can4 = parseFloat(document.getElementById('can4').value);

	pre1 = parseFloat(document.getElementById('pre1').value);
	pre2 = parseFloat(document.getElementById('pre2').value);
	pre3 = parseFloat(document.getElementById('pre3').value);
	pre4 = parseFloat(document.getElementById('pre4').value);

	res = new Array(0.0, 0.0, 0.0, 0.0);
	
	if( ! isNaN(can1) && ! isNaN(pre1) ){
		res[0] = pre1 / can1;	
	}	
	if( ! isNaN(can2) && ! isNaN(pre2) ){
		res[1] = pre2 / can2;	
	}	
	if( ! isNaN(can3) && ! isNaN(pre3) ){
		res[2] = pre3 / can3;
	}	
	if( ! isNaN(can4) && ! isNaN(pre4) ){
		res[3] = pre4 / can4;
	}	

	// calcula el mayor que no sea 0
	// resultado = Math.max.apply(Math, res);
	input = -1;
	valor = 7199254740991;
	for( i=0; i < res.length; i++ ){
		if( res[i] != 0){
			tmp = i + 1;
			document.getElementById('res'+tmp).value = res[i].toFixed(2);
			if(res[i] <= valor ){	
				input = i;
				valor = res[i];
			}
		}
//console.log(tmp, res[i], 'res'+tmp, input);
	}
	// muestra el resultado
	if(input != -1) {
		tmp2 = input + 1
		document.getElementById('res'+tmp2).style.backgroundColor = '#0f0';
	}

//console.log('final',valor, input, tmp2);
}

function limpiarResultados(){
	document.getElementById('res1').style.backgroundColor = '#fff';
	document.getElementById('res2').style.backgroundColor = '#fff';
	document.getElementById('res3').style.backgroundColor = '#fff';
	document.getElementById('res4').style.backgroundColor = '#fff';
}

function limpiar(){
	num = this.id;
console.log(num);
	document.getElementById('nom'+num).value = '';
	document.getElementById('can'+num).value = '';
	document.getElementById('pre'+num).value = '0.00';
	document.getElementById('res'+num).value = '';
	document.getElementById('res'+num).style.backgroundColor = '#fff';
}

function autoselect(){
	this.select();
}

// Engancha eventos a la interfaz
document.getElementById('can1').addEventListener("change", limpiarResultados);
document.getElementById('can2').addEventListener("change", limpiarResultados);
document.getElementById('can3').addEventListener("change", limpiarResultados);
document.getElementById('can4').addEventListener("change", limpiarResultados);
document.getElementById('pre1').addEventListener("focus", autoselect);
document.getElementById('pre2').addEventListener("focus", autoselect);
document.getElementById('pre3').addEventListener("focus", autoselect);
document.getElementById('pre4').addEventListener("focus", autoselect);
document.getElementById('pre1').addEventListener("keypress", limpiarResultados);
document.getElementById('pre2').addEventListener("keypress", limpiarResultados);
document.getElementById('pre3').addEventListener("keypress", limpiarResultados);
document.getElementById('pre4').addEventListener("keypress", limpiarResultados);
document.getElementById('1').addEventListener("click", limpiar);
document.getElementById('2').addEventListener("click", limpiar);
document.getElementById('3').addEventListener("click", limpiar);
document.getElementById('4').addEventListener("click", limpiar);
document.getElementById('compare').addEventListener("click", comparar);

//console.log('final');