// Wrapped by Đurađ Radojičić (djura-san) <office@lab21.net>
//
// as seen on http://stackoverflow.com/a/12287599

upper_number_limit='500000';

function getPrimes(max) {
  // count execution time
  var start = new Date().getTime();

  // getPrimes main stuff
  var sieve = [], i, j, primes = [];
  for (i = 2; i <= max; ++i) {
      if (!sieve[i]) {
          // i has not been marked -- it is prime
          primes.push(i);
          for (j = i << 1; j <= max; j += i) {
              sieve[j] = true;
          }
      }
  }

  // end execution time counting and start processing time info
  var end = new Date().getTime();
  var time = end - start;

  // Display number of found prime numbers
  // basically, it just counts array elements of primes.

    var cnt = 0;
    for (var i = 0; i < primes.length; i++) {
      if (primes[i] !== undefined) {
        ++cnt;
      }
    }
    // if number is less/equal to "upper_number_limit", display number count
    document.getElementById('number_count').style.display = 'block';
    document.getElementById('result').innerHTML = '<span class="results animation">' + cnt + '</span>';

  // display results
  toggle_content();
  document.getElementById('loading').style.display = 'none';
  document.getElementById('time').innerHTML = '<b>0 - ' + max + '</b>: <br/><span class="results animation"> ' + time + 'ms </span>';

  return primes;
}

// very crappy function to toggle main content
// there should be a better way to do this :-/
function toggle_content() {
  form = document.getElementById("input_form");
  res = document.getElementById("result_content");
  sys_info = document.getElementById("sys-info");
  if (form.style.display == "block") {
    res.style.display="none";
  } else {
    form.style.display="none";
    form.style.visibility = 'visible';
    
    res.style.display="block";
    res.style.visibility = 'visible';
    
    sys_info.style.display="block";
    sys_info.style.visibility = 'visible';
  }
}


function init_helper() {
  document.getElementById('loading').style.display = 'block';
  document.getElementById('input_form').style.visibility = 'hidden';
  document.getElementById('result_content').style.visibility = 'hidden';
  document.getElementById('limit_warning').style.display = 'none';
  document.getElementById('sys-info').style.display = 'none';
  console.log('Starting calculation...');
  setTimeout("getPrimes(num_value);",500);
}

function init() {
  num_value = document.getElementById('number_range').value;

  // if number is not entered, you will get no results!
  if (num_value === "") {
    //alert('No Number!');
    console.log('Input: no number');
    return;
  }


  if (Number(num_value) > Number(upper_number_limit)) {
    if (confirm(document.webL10n.get("warning_alert"))) {
        console.log('Input: number is greater than ' + upper_number_limit);
        init_helper();
    }
  } else {
      console.log('Input: no number');
      init_helper();
    }

}