(function($_) {

	"use strict";
	
	// Check for indexedDB prefixed methods
	var indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
	var IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction || window.msIDBTransaction;
	var IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange || window.msIDBKeyRange;
	var database;
	
	if ( ! indexedDB)
	{
		alert("Sorry! Your browser doesn't support IndexedDB");
		return;
	}

	// Open the database (returns IDBOpenDBRequest )
	// indexedDB.open([db name], [version number])
	var request = indexedDB.open("notepad", 1);
	
	// Connection error
	request.onerror = function(event) {
		console.log(event.target.error);
	};
	
	// Connection success (sets db as an IDBDatabase)
	request.onsuccess = function(event) {
		database = request.result;
		showNotes();
	};
	
	// When the database needs to be created
	request.onupgradeneeded = function(event) {
		var db = event.target.result;
		var objectStore = db.createObjectStore("notes", {
			keyPath: "id",
			autoIncrement: true
		});
	};
	
	function showNotes()
	{
		var notes="";
		var objectStore = database.transaction("notes").objectStore("notes");
		objectStore.openCursor().onsuccess = function(event) {
			var cursor = event.target.result;
			
			if (cursor) 
			{
				var link='<a class="notelist" id="'+cursor.key+'" href="#">'+cursor.value.title+'</a>';
				link += '<img class="delete" src="img/del.png" height="30" id="'+cursor.key+'" />';
				var listItem = '<li>'+link+'</li>';
				notes = notes+listItem;
				cursor.continue();
			}
			else
			{
				$_("#notes").el.innerHTML="<ul>"+notes+"</ul>";
			}
			
			
			$_(".notelist").event.add("click", function(e) {
				createNote(this.id);
			});
		
			$_(".delete").event.add("click", function(e) {
				deleteNote(parseInt(this.id, 10));
			});
		};
		
	}
	
	function createNote(id)
	{
		$_("#editor").el.style.display = "block";
		$_("#editor").el.focus();
		$_("#back").el.style.display = "block";
		$_("#add").el.style.display = "none";
		$_("#notes").el.style.display = "none";
		 
		if (parseInt(id, 10) !=0)
		{
			var result = database.transaction("notes").objectStore("notes").get(parseInt(id, 10));
			
			result.onsuccess = function(event) {
				$_("#editor").el.innerHTML = event.target.result.body;
				$_("#flag").el.value = id;
		 	};
		}
		 
	}
	
	function goBack()
	{
		var note = {};
		note.body = $_("#editor").el.innerHTML;
		note.title = getTitle(note.body);
		note.date = getDate();
		var flag = parseInt($_("#flag").el.value, 10);
		
		if (flag !== 0)
		{
			note.id = flag;
		}
		
		if (note.title.trim() === "")
		{
			window.location.reload();
		}
		else
		{
			addNote(note);
		}
	}
	
	function getDate()
	{
		var date = new Date();
		var month = parseInt(date.getMonth(), 10) + 1;
		return date.getDate() + "/" + month + "/" + date.getFullYear();
	}
	
	function getTitle(body)
	{
		body = body.replace(/(<([^>]+)>)/ig, "");
		
		if (body.length > 20)
		{
			body = body.substring(0,20) + "...";
		}
		
		return body;
	}
	
	function addNote(note)
	{
		var transaction = database.transaction(["notes"], "readwrite");
		var objectStore = transaction.objectStore("notes");
		var request = objectStore.put(note);
		
		request.onsuccess = function(event) {
			$_("#flag").el.value="0";
			window.location.reload();
		};
	}
	
	function deleteNote(id)
	{
		var request = database.transaction(["notes"], "readwrite").objectStore("notes").delete(parseInt(id, 10));
			
		request.onsuccess = function(event) {
			window.location.reload();
		};
	}
	
	// Proper event attachment for the add/list switch button
	$_("#back").event.add("click", goBack);
	$_("#add").event.add("click", function(e) {
		createNote(0);
		e.preventDefault();
	});

}($_));