/*
The EntityDebris will randomly spawn a certain count of EntityDebrisParticle 
entities for a certain duration.

The spawn position of the EntityDebrisParticle is inside the area occupied
by the EntityDebris entity. I.e. make the EntityDebris larger in Weltmeister
to increase the area in which particles will spawn.

Keys for Weltmeister:

duration
	Duration in seconds over which to spawn EntityDebrisParticle entities.
	Default: 5
	
count
	Total count of particles to spawn during the #duration# time span.
	Default: 5
*/

ig.module(
	'game.entities.badfruit'
)
.requires(
	'impact.entity',
	'game.entities.particle',
	'game.entities.portal'
)
.defines(function(){


EntityBadfruit = ig.Entity.extend({
		
		name : "Badfruit",
		bounciness: 0,
		vel: {x: 0, y: 100},
		size: { x: 8, y: 8 },
		offset: {x: 0, y: 0},
		score: 100,
		
		type: ig.Entity.TYPE.B,
		checkAgainst: ig.Entity.TYPE.A,
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		friction: {x:100, y: 100},
		
		animSheet:new ig.AnimationSheet( 'media/badfruit.png', 8, 8 ),
		
		
		init: function( x, y, settings) {
			this.parent( x, y, settings );

            this.addAnim('bad0', 0.1, [0]);
            this.addAnim('bad1', 0.1, [1]);
            this.addAnim('bad2', 0.1, [2]);
            this.addAnim('bad3', 0.1, [3]);
            
            var fruit = Math.random()*4;
            
            if (fruit < 1)
                    this.currentAnim = this.anims.bad0;
            if (fruit >= 1 && fruit < 2)
                    this.currentAnim = this.anims.bad1;
            if (fruit >= 2 && fruit < 3)
                    this.currentAnim = this.anims.bad2;
            if (fruit >= 3)
                    this.currentAnim = this.anims.bad3;
                    
		},
	
	
	
		update: function() {
			//Keep within bounds of play area
			if (this.pos.x > (ig.game.screenWidth-2))
			{
				this.pos.x = 0;
			}
			if (this.pos.x < 0)
			{
				this.pos.x = (ig.game.screenWidth-2);
			}
			if (this.pos.y > ig.game.screenHeight)
			{
				this.pos.y = 0;
			}
			
			this.parent();
		},
	
		
        
        handleMovementTrace: function( res ) {
            this.parent( res );
            
            //Collision with a floor? Then splat!
            if( res.collision.y ) {
                ig.game.spawnEntity( EntityBadFruitParticle, this.pos.x+2, this.pos.y+1 );
				ig.game.spawnEntity( EntityBadFruitParticle, this.pos.x+2, this.pos.y+1 );
                ig.game.spawnEntity( EntityBadFruitParticle, this.pos.x+2, this.pos.y+1 );
                this.kill();
                ig.game.soundSplat.play();
            }
		}
        
});



EntityBadFruitParticle = EntityParticle.extend({
    lifetime: 3,
    fadetime: 0.5,
    bounciness: 0.5,
    vel: {x: 500, y: 0},
    friction: {x:0, y: 0},
	
	type: ig.Entity.TYPE.B,
    checkAgainst: ig.Entity.TYPE.A, 				
    collides: ig.Entity.COLLIDES.PASSIVE,
    
    animSheet: new ig.AnimationSheet('media/badfruitfragment.png', 4, 4),
    
    init: function (x, y, settings) {
        this.vel.x = Math.random().map( 0,1, -500, 500 );
        
        this.addAnim('frag0', 0.1, [0]);
        this.addAnim('frag1', 0.1, [1]);
        this.addAnim('frag2', 0.1, [2]);
        this.addAnim('frag3', 0.1, [3]);
		
		var frag = Math.random()*4;
		
		if (frag < 1)
				this.currentAnim = this.anims.frag0;
		if (frag >= 1 && frag < 2)
				this.currentAnim = this.anims.frag1;
		if (frag >= 2 && frag < 3)
				this.currentAnim = this.anims.frag2;
		if (frag >= 3)
				this.currentAnim = this.anims.frag3;
        
        this.parent(x, y, settings);
        

    },
    
    
   	update: function() {
		this.parent();
		
		//If drops off bottom or sides of screen then kill it
		if (this.pos.y > ig.game.screenHeight)
			this.kill();
		if ((this.pos.x > ig.game.screenWidth) || (this.pos.x < 0))
			this.kill();
    },
	

	
	
	
	check: function( other ) {
		 if (other.name == 'Player')
            {
				this.kill();

				ig.game.reducePlayerScore(200, true);
				ig.game.soundHit.play();
			}
	}
    
});



});