ig.module(
	'game.entities.badfruitspawner'
)
.requires(
	'impact.entity',
	'game.entities.badfruit'
)
.defines(function(){

EntityBadfruitspawner = ig.Entity.extend({
		_wmScalable: true,
		_wmDrawBox: true,
		_wmBoxColor: 'rgba(200, 50, 200, 0.9)',
		
		size: {x: 8, y: 8},
		
		delayTimer: null,
        delay:  1,
		
		
		init: function( x, y, settings ) {
			this.parent( x, y, settings );
			
			this.delayTimer = new ig.Timer();
		},
		
		
		update: function(){
            
			if (!ig.game.levelFrozen)
			{
				if( this.delayTimer.delta() > this.delay) {
					ig.game.spawnEntity( EntityBadfruit, this.pos.x, this.pos.y );
					this.delay = Math.random().map( 0, 1, 0, 6);
					this.delayTimer.set(0);
				}
			}
		}
});



});