ig.module(
	'game.entities.bomb'
)
.requires(
	'impact.entity',
	'game.entities.particle',
	'game.entities.portal'
)
.defines(function(){


EntityBomb = ig.Entity.extend({
		
		name : "Bomb",
		bounciness: 0.5,
		vel: {x: 200, y: 200},
		size: { x: 8, y: 8 },
		offset: {x: 0, y: 0},
		score: 100,
		
		onRightConveyor : false,
		onLeftConveyor : false,
		
		type: ig.Entity.TYPE.B,
		checkAgainst: ig.Entity.TYPE.A,
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		friction: {x:100, y: 100},
		detonationTimer: null,
		detonation: 0,
		
		animSheet:new ig.AnimationSheet( 'media/bomb.png', 8, 8 ),
		
		
		init: function( x, y, settings) {
			this.parent( x, y, settings );
			
			//Random velocity
            this.vel.x = Math.random().map( 0,1, -200, 200 );
            this.vel.y = Math.random().map( 0,1, 0, -200 );
			this.addAnim( 'idle', 1, [0] );
			this.currentAnim = this.anims.idle;
			
			//Random detonation time
			this.detonationTimer = new ig.Timer();
			this.detonation = 1 + Math.random()*4;
		},
	
	
	
		update: function() {
			//Keep within bounds of play area
			if (this.pos.x > (ig.game.screenWidth-2))
			{
				this.pos.x = 0;
			}
			if (this.pos.x < 0)
			{
				this.pos.x = (ig.game.screenWidth-2);
			}
			if (this.pos.y > ig.game.screenHeight)
			{
				this.pos.y = 0;
			}
			
			//Move bomb if on conveyor
			if (this.onRightConveyor)
				this.accel.x += 500;
			if (this.onLeftConveyor)
				this.accel.x -= 500;
				
			
			ig.game.spawnEntity( EntitySparkParticle, this.pos.x+7, this.pos.y+1);
			
			//Ready to detonate?
			if (this.detonationTimer.delta() > this.detonation)
			{
				ig.game.soundExplosion.play();
				ig.game.spawnEntity( EntityBombFragment, this.pos.x+4, this.pos.y+4 );
				ig.game.spawnEntity( EntityBombFragment, this.pos.x+4, this.pos.y+4 );
				ig.game.spawnEntity( EntityBombFragment, this.pos.x+4, this.pos.y+4 );
				this.kill();
			}
			
			//Move!
			this.parent();
			
			//As there is no way to tell when the player is NOT colliding with a conveyor, instead we assume not and set the flag to false
			//If we are still on a conveyor this will get set back to true by the conveyor collision check method before next update
			this.onRightConveyor = false;
			this.onLeftConveyor = false;
		},
	
		
});



EntityBombFragment = EntityParticle.extend({
    lifetime: 3,
    fadetime: 0.5,
    bounciness: 0.6,
    vel: {x: 200, y: -300},
	
	type: ig.Entity.TYPE.B,
    checkAgainst: ig.Entity.TYPE.A, 				
    collides: ig.Entity.COLLIDES.PASSIVE,
    
    animSheet: new ig.AnimationSheet('media/bombfragment.png', 4, 4),
    
    init: function (x, y, settings) {
        this.addAnim('frag0', 1, [0]);
        this.addAnim('frag1', 1, [1]);
        this.addAnim('frag2', 1, [2]);
        this.addAnim('frag3', 1, [3]);
		
		var frag = Math.random()*4;
		
		if (frag < 1)
				this.currentAnim = this.anims.frag0;
		if (frag >= 1 && frag < 2)
				this.currentAnim = this.anims.frag1;
		if (frag >= 2 && frag < 3)
				this.currentAnim = this.anims.frag2;
		if (frag >= 3)
				this.currentAnim = this.anims.frag3;
		
        this.parent(x, y, settings);
    },
	
	
	update: function() {
		this.parent();
		
		//If drops off bottom or sides of screen then kill it
		if (this.pos.y > ig.game.screenHeight)
			this.kill();
		if ((this.pos.x > ig.game.screenWidth) || (this.pos.x < 0))
			this.kill();
    },
	
	
	
	check: function( other ) {
		 if (other.name == 'Player')
            {
				this.kill();

				ig.game.reducePlayerScore(200, true);
				ig.game.soundHit.play();
			}
	}
    
});



});