ig.module(
	'game.entities.bombspawner'
)
.requires(
	'impact.entity',
	'game.entities.bomb'
)
.defines(function(){

EntityBombspawner = ig.Entity.extend({
		_wmScalable: true,
		_wmDrawBox: true,
		_wmBoxColor: 'rgba(50, 50, 250, 0.9)',
		
		size: {x: 8, y: 8},
		
		delayTimer: null,
        delay:  1,
		
		
		init: function( x, y, settings ) {
			this.parent( x, y, settings );
			
			this.delayTimer = new ig.Timer();
		},
		
		
		update: function(){
            
            if( this.delayTimer.delta() > this.delay) {
                ig.game.spawnEntity( EntityBomb, this.pos.x, this.pos.y );
                this.delay = Math.random().map( 0, 1, 0, 3);
                this.delayTimer.set(0);
            }
			
		}
});



});