ig.module(
	'game.entities.bossfruit'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function () {

    EntityBossfruit = ig.Entity.extend({

        name: 'Boss',

        // The collision size is a bit smaller than the animation frames, so we have to move the collision box a bit (offset)
        size: { x: 28, y: 32 },
        offset: { x: 2, y: 0 },

        maxVel: { x: 70, y: 500 },
        friction: { x: 500, y: 0 },
		health: 200,
		score:  5000,

        flip: false,
		speed: 5,
		changeDirectionTimer: null,
		playOnce: false,

		
        type: ig.Entity.TYPE.B, 										// Enemy collision group
        checkAgainst: ig.Entity.TYPE.A,
        collides: ig.Entity.COLLIDES.PASSIVE,
		
				
        animSheet: new ig.AnimationSheet('media/bossfruit.png', 32, 32),


		//***********************
		// Initialise
		//***********************
        init: function (x, y, settings) {
            this.parent(x, y, settings);

            // Add the animations
            this.addAnim('idle', 1, [1]);
			this.addAnim('idleZapped', 1, [3]);
			this.addAnim('jump', 1, [0]);
			this.addAnim('jumpZapped', 1, [2]);
            
            this.changeDirectionTimer = new ig.Timer();
        },

		
		//***********************
		// Update
		//***********************
        update: function () {
			
			if (this.health < 0) {
				ig.game.levelCompleted();
				this.kill();
				ig.game.soundExplosion.play();
				for (i=0; i<50; i++)
					ig.game.spawnEntity( EntityBossParticle, this.pos.x+16, this.pos.y+16 );
					
				ig.game.spawnEntity( EntityFloatingscore, this.pos.x, this.pos.y, {text : this.score.toString()} );
				ig.game.currentScore += this.score;
			}
				
			//this.currentAnim.alpha = 1 / this.health;
			
			if (this.currentAnim == this.anims.idleZapped)
				this.currentAnim = this.anims.idle;
			
			if (this.currentAnim == this.anims.jumpZapped)
				this.currentAnim = this.anims.idle;

            //Just move boss randomly
            if (this.standing)
            {
                this.accel.x = 0;
                
                if (this.changeDirectionTimer.delta() > 0.3)
                {
                    //Decide whether to jump
                    var ychange = Math.random()*5
                    if (ychange < 1)
                    {
						this.playOnce = true;
						this.currentAnim = this.anims.jump;
						
                        this.vel.y = -Math.random()*400;
                        ig.game.soundEvilJump.play();
                        
                        
                        //Decide whether to jump left,right or stand still
                        var xchange = Math.random()*2;
                        
                        if (xchange < 1)
                        {
                             this.accel.x = -200;
                             this.flip = true;
                        }
                        else if (xchange > 1)
                        {
                             this.accel.x = 200;
                             this.flip = false;
                        }
                        
                        
                    }
                
                
                    this.changeDirectionTimer.set(0);
                    
                }
            
            }
				
	
			//Move the boss
            this.vel.x = this.speed * this.accel.x;
			
			
			//Keep within bounds of play area
			if (this.pos.x > ig.game.screenWidth)
				this.pos.x = 0;
			if (this.pos.x < 0)
				this.pos.x = ig.game.screenWidth;
			if (this.pos.y > ig.game.screenHeight)
				this.pos.y = 0;
			
			
            //Move!
            this.parent();
        },

		
		
		handleMovementTrace: function( res ) {
            this.parent( res );
            
            //Collision with a wall? return!
            if( res.collision.x ) {
              
				this.accel.x = -this.accel.x;
            }
			
			if( res.collision.y ) {
				
				if (this.standing)
				{
					if (this.playOnce)
					{
						this.currentAnim = this.anims.idle;
						ig.game.spawnEntity( EntityBossParticle, this.pos.x+16, this.pos.y+16 );
						ig.game.spawnEntity( EntityBossParticle, this.pos.x+16, this.pos.y+16 );
						ig.game.spawnEntity( EntityBossParticle, this.pos.x+16, this.pos.y+16 );
						ig.game.spawnEntity( EntityBossParticle, this.pos.x+16, this.pos.y+16 );
						ig.game.spawnEntity( EntityBossParticle, this.pos.x+16, this.pos.y+16 );
					}
				}
				
				if (this.playOnce)
				{
					ig.game.soundSplat.play();
					ig.game.screenShaker.timedShake(50, 0);
					this.playOnce = false;
				}
			}
		},	





		check: function( other ) {
			if (other.name == 'Player')
				{
						// Take some score off
						ig.game.reducePlayerScore(50, false);
						ig.game.soundHit.play();
				}
		},
		
		
		zapMe: function() {
			if (this.currentAnim == this.anims.idle)
				this.currentAnim = this.anims.idleZapped;
			
			if (this.currentAnim == this.anims.jump)
				this.currentAnim = this.anims.jumpZapped;
			
			ig.game.soundSplat.play();
			
			this.health -= 1;
			
			
		}
     


    });

	
	
	
EntityBossParticle = EntityParticle.extend({
    lifetime: 5,
    fadetime: 0.5,
    bounciness: 0.5,
    vel: {x: 500, y: 0},
    friction: {x:0, y: 0},
	
	type: ig.Entity.TYPE.B,
    checkAgainst: ig.Entity.TYPE.A, 				
    collides: ig.Entity.COLLIDES.PASSIVE,
    
    animSheet: new ig.AnimationSheet('media/bossfragment.png', 4, 4),
    
    init: function (x, y, settings) {
        this.vel.x = Math.random().map( 0,1, -500, 500 );
		this.vel.y = Math.random().map( 0,1, -500, 500 );
        
        this.addAnim('frag0', 0.1, [0]);
        this.addAnim('frag1', 0.1, [1]);
        this.addAnim('frag2', 0.1, [2]);
        this.addAnim('frag3', 0.1, [3]);
		
		var frag = Math.random()*4;
		
		if (frag < 1)
				this.currentAnim = this.anims.frag0;
		if (frag >= 1 && frag < 2)
				this.currentAnim = this.anims.frag1;
		if (frag >= 2 && frag < 3)
				this.currentAnim = this.anims.frag2;
		if (frag >= 3)
				this.currentAnim = this.anims.frag3;
        
        this.parent(x, y, settings);
        

    },
    
    
   	update: function() {
		this.parent();
		
		//If drops off bottom or sides of screen then kill it
		if (this.pos.y > ig.game.screenHeight)
			this.kill();
		if ((this.pos.x > ig.game.screenWidth) || (this.pos.x < 0))
			this.kill();
    },
	

	
	
	
	check: function( other ) {
		 if (other.name == 'Player')
            {
				this.kill();

				ig.game.reducePlayerScore(200, true);
				ig.game.soundHit.play();
			}
	},
	
	    
});	
	
	
	


});