//Holds a conversation based on speech bubbles between two entities


ig.module(
	'game.entities.conversation'
)
.requires(
	'impact.entity',
	'game.entities.chatbubble'
)
.defines(function(){

EntityConversation = ig.Entity.extend({
	size: {x: 8, y: 8},
	
	_wmScalable: true,
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(255, 255, 50, 0.9)',
	
	entity1: null,
    entity2: null,
	waitTimer: null,
	
	type: ig.Entity.TYPE.NONE,
	checkAgainst: ig.Entity.TYPE.A,
	collides: ig.Entity.COLLIDES.NEVER,
	
	startConversation: false,
	chat: new Array(),
	currentText: 0,
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.waitTimer = new ig.Timer();
		
		//Setup the two entities having the chat
		var player = ig.game.getEntityByName('Player');
		var hobo = ig.game.getEntityByName('Hobo');
		this.entity1 = player;
		this.entity2 = hobo;
		
		//Setup the things that will be said between the two entities
		if (ig.game.currentLevelNum < 30)
		{
			this.chat.push({entity: 1, text: "Hello, I'm Professor Plum.  Who are you?"});
			this.chat.push({entity: 2, text: "oh hello, I'm just a random hobo living in the forest."});
			this.chat.push({entity: 1, text: "Why do you live in the forest?"});
			this.chat.push({entity: 2, text: "Well I used to live in a lovely house until I lost my job."});
			this.chat.push({entity: 1, text: "You lost your job?"});
			this.chat.push({entity: 2, text: "Yes. I used to work in the Fruit Squash factory until the Evil Professor fired everybody!"});
			this.chat.push({entity: 1, text: "What? Why did he do that?"});
			this.chat.push({entity: 2, text: "Beats me. One day he just went completely mad and took over."});
			this.chat.push({entity: 2, text: "He started stealing all the fruit we used to squash for our fabulous fruit drinks"});
			this.chat.push({entity: 2, text: "and said he intended to start making rotten fruit drinks instead."});
			this.chat.push({entity: 2, text: "Now nobody can get into the factory."});
			this.chat.push({entity: 1, text: "That's terrible! He must be stopped!"});
			this.chat.push({entity: 2, text: "I know - can you help us Professor?"});
			this.chat.push({entity: 1, text: "I'll try - but how can I get into the factory?"});
			this.chat.push({entity: 2, text: "Well, I know a secret passage way to get you in..."});
			this.chat.push({entity: 2, text: "Just walk past me, you can't miss it."});
			this.chat.push({entity: 1, text: "What should I do once I'm inside?"});
			this.chat.push({entity: 2, text: "The factory has 30 levels.  You must collect the fruit on each level and take it to the juicing machine."});
			this.chat.push({entity: 2, text: "If you manage to do it I think you may be able to defeat the Evil Professor's plans."});
			this.chat.push({entity: 1, text: "How do I move from level to level?"});
			this.chat.push({entity: 2, text: "Don't worry, the fruit has magical properties. Once its in the jucing machine it'll be obvious!"});
			this.chat.push({entity: 1, text: "Ok I'll try my best!"});
			this.chat.push({entity: 2, text: "Good Luck! oh and one last thing. The Evil Professor has lots of evil minions helping him!"});
			this.chat.push({entity: 1, text: "Wait! What?"});
		}
		else
		{
			this.chat.push({entity: 1, text: "Hey there! I'm back!"});
			this.chat.push({entity: 2, text: "ooh hello again - how did it go?"});
			this.chat.push({entity: 1, text: "I did it! The Evil Professor has been defeated!"});
			this.chat.push({entity: 2, text: "oh that's wonderful! Very well done!"});
			this.chat.push({entity: 2, text: "Now me and my friends can go back to working in the factory"});
			this.chat.push({entity: 2, text: "and start creating wonderful fruit squash drinks again!"});
			this.chat.push({entity: 2, text: "Thank you so much professor - I'm so happy I could sing!"});
			this.chat.push({entity: 2, text: "In fact I'm so grateful I'm going to name a new drink after you!"});
			
		}
		
		
		this.nextConversationText();
	},
	
	
	update: function(){
		
		if(this.waitTimer.delta() > 0 ) {
            this.waitTimer.set(5);
            this.nextConversationText();
		}
	},
	
	
	
	nextConversationText: function() {
		//Creates a chat bubble for the relevant entity for the next piece of text
		if (this.startConversation == true)
		{
			if (this.currentText < this.chat.length)
			{
				//When we hit a certain line in the starting conversation send the hobo back to sleep
				if (this.chat[this.currentText].text == "Good Luck! oh and one last thing. The Evil Professor has lots of evil minions helping him!")
				{
				var hobo = ig.game.getEntityByName('Hobo');
					if (hobo)
						hobo.currentAnim = hobo.anims.sleepy;
					
					var zeds = ig.game.getEntityByName('Zedspawner');
					if (zeds)
						zeds.sleeping = true;
				}
				
				//When we hit a certain line in the ending conversation make the hobo smile
				if (this.chat[this.currentText].text == "oh that's wonderful! Very well done!")
				{
				var hobo = ig.game.getEntityByName('Hobo');
					if (hobo)
						hobo.currentAnim = hobo.anims.happy;
				}
				
				//When we hit a certain line in the ending conversation make the hobo sing
				if (this.chat[this.currentText].text == "In fact I'm so grateful I'm going to name a new drink after you!")
				{
					var hobo = ig.game.getEntityByName('Hobo');
						if (hobo)
							hobo.currentAnim = hobo.anims.singing;
						
						ig.music.play('Fruit');
				}
				
							
				//Conversation is still going
				if (this.chat.length > this.currentText)
				{
					//Decide which entity to attach the speech bubble to
					if (this.chat[this.currentText].entity == 1)
					{
						ig.game.spawnEntity(EntityChatbubble, this.entity1.pos.x, this.entity1.pos.y, {
							follow: this.entity1,
							msg: this.chat[this.currentText].text,
						});
					}
					else if (this.chat[this.currentText].entity == 2)
					{
						ig.game.spawnEntity(EntityChatbubble, this.entity1.pos.x, this.entity1.pos.y, {
							follow: this.entity2,
							msg: this.chat[this.currentText].text,
						});
					}
					
					//Advance to next piece of text in conversation
					this.currentText += 1;
				}
				else {
					//Conversation has finished
				
				}
			}
			
		}
	},
	
	
	triggeredBy: function( entity, trigger ) {
		
		var zeds = ig.game.getEntityByName('Zedspawner');
		if (zeds)
			zeds.sleeping = false;
		
		var hobo = ig.game.getEntityByName('Hobo');
		if (hobo)
		{
			hobo.currentAnim = hobo.anims.idle;
			hobo.currentAnim.flip.x = true;
		}
			
		this.startConversation = true;
		this.waitTimer.set(5);
		this.nextConversationText();
	}
	
});

});