ig.module(
	'game.entities.conveyor'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityConveyor = ig.Entity.extend({
    
    name : 'Conveyor',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 32, y: 8},
    zIndex: -1000,
	direction: "Right",			// Direction that converer is moving

    type: ig.Entity.TYPE.B, 							
	checkAgainst: ig.Entity.TYPE.BOTH, 					
	collides: ig.Entity.COLLIDES.FIXED,	
    
	
    animSheet: new ig.AnimationSheet( 'media/conveyor.png', 32, 8 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'idle', 0.1, [0,1,2,3] );
		
		if (this.direction != "right")
			this.currentAnim.flip.x = true;
    },
    

    
    update: function() {
        this.parent();
    },
	
    
    check: function (other) {
        
		if (this.direction == "right")
			other.onRightConveyor = true;
		else
			other.onLeftConveyor = true;
    },


	
});

});