ig.module(
	'game.entities.cuthbert'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function () {

    EntityCuthbert = ig.Entity.extend({

        name: 'Cuthbert',

        // The collision size is a bit smaller than the animation frames, so we have to move the collision box a bit (offset)
        size: { x: 8, y: 14 },
        offset: { x: 4, y: 2 },

        maxVel: { x: 70, y: 150 },
        friction: { x: 500, y: 0 },
		health: 100,

        flip: false,
        accelGround: 10,
        accelAir: 10,
        jump: 170,
		speed: 5,
		changeDirectionTimer: null,
		throwBombTimer : null,

		
        type: ig.Entity.TYPE.B, 										// Enemy collision group
        checkAgainst: ig.Entity.TYPE.NONE,
        collides: ig.Entity.COLLIDES.PASSIVE,
		
		hasGun: false,
		shootingLaser: 	false,
		shootingLaserTimer: null,
		
        animSheet: new ig.AnimationSheet('media/cuthbert.png', 16, 16),
		laughPlayOnce: true,


		//***********************
		// Initialise
		//***********************
        init: function (x, y, settings) {
            this.parent(x, y, settings);

            // Add the animations
            this.addAnim('idle', 1, [0]);
            this.addAnim('run', 0.07, [0, 1, 2, 3]);
            this.addAnim('jump', 1, [1]);
            this.addAnim('fall', 1, [1]);
			this.addAnim('zapped', 0.1, [4,5]);
            
            //If nemesis has a gun then start the timer to time shots
			if (this.hasGun)
				this.shootingLaserTimer = new ig.Timer();
				
			this.changeDirectionTimer = new ig.Timer();
			this.throwBombTimer = new ig.Timer();
			
			if (ig.game.soundMadLaugh)
				ig.game.soundMadLaugh.play();
        },

		
		//***********************
		// Update
		//***********************
        update: function () {

			if (ig.game.levelComplete)
				if (this.laughPlayOnce)
				{
					ig.game.soundMadLaugh.play();
					this.laughPlayOnce = false;
					this.kill();
				}
		
			if (this.playerNearby())
			{
				this.chasePlayer();
							
				if (this.hasGun)
					if (!this.shootingLaser)
					{
						if (this.shootingLaserTimer.delta() > 0.3)
						{
							this.shootingLaser = true;	
							ig.game.soundLaser.play();
							ig.game.spawnEntity(EntityLaser, this.pos.x + 2,  this.pos.y + 8, { flip: this.flip, enemyName: this.name });
							this.shootingLaserTimer.set(0);
						}
					}
			}
			else
			{
				//Player is not nearby so just move nemesis randomly
				if (this.standing)
				{
					if (this.changeDirectionTimer.delta() > 0.5)
					{
						
						//Decide whether to jump
						var ychange = Math.random()*4
						if (ychange < 1)
						{
							this.vel.y = -this.jump;
							ig.game.soundEvilJump.play();
						}
					
						//Decide whether to move left,right or stand still
						var accel = this.standing ? this.accelGround : this.accelAir;
						
						var xchange = Math.random()*5;
						
						if (xchange < 1)
						{
							 this.accel.x = -accel;
							 this.flip = true;
						}
						else if (xchange >= 1 && xchange < 2)
						{
							 this.accel.x = accel;
							 this.flip = false;
						}
						else if (xchange >= 2 && xchange < 3)
						{
							this.accel.x = 0;
						}
					
					
						this.changeDirectionTimer.set(0);
						
					}
				
				}
				
			}
			
	
			//Move the nemesis
			this.vel.x = this.speed * this.accel.x;
			
			
			//Keep within bounds of play area
			if (this.pos.x > ig.game.screenWidth)
				this.pos.x = 0;
			if (this.pos.x < 0)
				this.pos.x = ig.game.screenWidth;
			if (this.pos.y > ig.game.screenHeight)
				this.pos.y = 0;
			

			//Set the current animation, based on the nemesis' speed
			if (this.vel.y < 0) {
				this.currentAnim = this.anims.jump;
			}
			else if (this.vel.y > 0) {
				this.currentAnim = this.anims.fall;
			}
			else if (this.vel.x != 0) {
				this.currentAnim = this.anims.run;
			}
			else {
				if (this.currentAnim != this.anims.zapped)
					this.currentAnim = this.anims.idle;
			}

			this.currentAnim.flip.x = this.flip;

			//Decide whether to throw a bomb
			if (this.throwBombTimer.delta() > 0.5)
			{
				var throwBomb = Math.random()*3
				if (throwBomb < 1)
				{
					ig.game.spawnEntity( EntityBomb, this.pos.x, this.pos.y );
				}
				this.throwBombTimer.set( 0 );
				
			}
			
			
			
			
            //Move!
            this.parent();
        },




		handleMovementTrace: function( res ) {
            this.parent( res );
            
            //Collision with a wall? return!
            if( res.collision.x ) {
                this.flip = !this.flip;
				this.accel.x = -this.accel.x;
                this.currentAnim.flip.x = this.flip;
            }
		},	




        //***********************
		// Chasing functions
		//***********************
		playerNearby:  function() {
			//Returns true if player is nearby to this robot
			var player = ig.game.getEntityByName('Player');
			
			if (Math.abs(this.pos.y - player.pos.y) < 30)
			{
				if (Math.abs(this.pos.x - player.pos.x) < 50)
				{
				    return true;
				}
			}
			
			return false;
		},
        
        
        chasePlayer: function() {
		    var player = ig.game.getEntitiesByType( EntityPlayer )[0];
			if( player ) {
				
				var accel = this.standing ? this.accelGround : this.accelAir;
				
				if (this.pos.x > (player.pos.x+15))
					{
					    this.accel.x = -accel;
						this.flip = true;
					};
		
				if (this.pos.x < (player.pos.x-15))
				{
					{
						this.accel.x = accel;
						this.flip = false;
					};
				}
				
				//Try to jump if player is above Nemesis
				if (this.standing)
					if (this.pos.y > (player.pos.y+20))
					{
						this.vel.y = -this.jump;
						ig.game.soundEvilJump.play();
					}
		
			}
				
		},

		
        
		//***********************
		// Gun stuff
		//***********************
		pickupGun: function() {
			ig.game.soundGunpickup.play();
			this.carryingGun = true;
			this.carryingGunTimer = new ig.Timer();
			this.shootingIceTimer = new ig.Timer();
		},

		dropGun: function() {
			this.carryingGun = false;
			this.shootingIce = false;
			this.carryingGunTimer = null;
			this.shootingIceTimer = null;
		},







    });



});