ig.module(
	'game.entities.dialog'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityDialog = ig.Entity.extend({
    
    name : 'Dialog',
    zIndex: -1000,
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 120, y: 15},
	text:   "LEVEL COMPLETE!",
	fontSize: 'small',
	
    type: ig.Entity.TYPE.NONE, 							
	
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
		
		this.size.x = ig.game.font.widthForString(settings.text);
		this.size.y = settings.height;
		
		this.fontSize = settings.fontSize;

    },
    
	
	center: function() {
		this.pos.x = (ig.game.screenWidth - this.size.x) / 2;
		this.pos.y = (ig.game.screenHeight - this.size.y) / 2;	
	},
	
	
	
	setText: function(text) {
		this.text = text;
		this.size.x = ig.game.font.widthForString(this.text);
	},

	
	
    draw: function() {
		
        ig.system.context.beginPath();
        ig.system.context.rect(
            this.pos.x * ig.system.scale, 
            this.pos.y * ig.system.scale, 
            this.size.x * ig.system.scale, 
            this.size.y * ig.system.scale
        );
        ig.system.context.closePath();
        ig.system.context.fill();
        
		if (this.fontSize == 'small')
			ig.game.smallfont.draw( this.text, this.pos.x + 1, this.pos.y + 2 );
		else
			ig.game.font.draw( this.text, this.pos.x + 1, this.pos.y + 2 );
		
        
        this.parent();
       
    },        
    
    
    
	
});

});