ig.module(
	'game.entities.fire'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityFire = ig.Entity.extend({
		name: 'Fire',
		size: {x: 8, y: 8},
		offset: {x: 0, y: 0},
		maxVel: {x: 100, y: 100},
		friction: {x: 150, y: 0},
		
		type: ig.Entity.TYPE.B, 							// Evil enemy group
		checkAgainst: ig.Entity.TYPE.A, 			        // Check for collisions against friendly group
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		isFrozen:  		false,
		isThawing: 		false,
		frozenTimer:    null,
		
        flip: false,
		speed: 40,
		score: 200,
		
		animSheet: new ig.AnimationSheet( 'media/fire.png', 8, 8 ),
		
		
		init: function( x, y, settings ) {
				this.parent( x, y, settings );
				
				this.addAnim( 'moving', 0.05, [0,1,2,3] );
				this.addAnim( 'frozen', 1, [4] );
				this.addAnim( 'thawing', 0.1, [5,6,7] );
				
				this.speed = this.speed + Math.floor(Math.random()*30);
				
				var direction = (Math.random() * 2 - 1);
		},
		
		
		update: function() {
				this.parent();
				
                
                //If fire drops off bottom or sides of screen then kill it
                if (this.pos.y > ig.game.screenHeight)
					this.kill();
				if ((this.pos.x > ig.game.screenWidth) || (this.pos.x < 0))
					this.kill();
					
				//Don't move if frozen
				if (this.isFrozen)
				{
					if( this.frozenTimer.delta() > 4 )
						if( !this.isThawing )
							this.thawMe();
			 
					if( this.frozenTimer.delta() > 8 )
						this.unfreezeMe();
				}
				else
				{
				    var xdir = this.flip ? -1 : 1;
					this.vel.x = this.speed * xdir;
				}
		},
		
		
		handleMovementTrace: function( res ) {
				this.parent( res );
				
				//Collision with a wall? return!
				if( res.collision.x ) {
					this.flip = !this.flip;
				}
		},	

		
		check: function( other ) {
            if (other.name == 'Player')
            {
				if (this.isFrozen)
				{
				    ig.game.soundGobbleup.play();
					this.kill();
					ig.game.spawnEntity( EntityFloatingscore, this.pos.x, this.pos.y, {text : this.score.toString()} );
					ig.game.currentScore += this.score;
				}
				else
				{
					ig.game.reducePlayerScore(200, true);
					ig.game.soundFire.play();
					this.kill();
				}
            }
		},
		
		
		
		//***********************
		// Freezing / Thawing
		//***********************
		freezeMe: function() {
		    this.currentAnim = this.anims.frozen;
		    this.isThawing = false;
		    this.isFrozen = true;
		    this.frozenTimer = new ig.Timer();
		},
	
	
		thawMe: function() {
	 	    this.isThawing = true;
			this.currentAnim = this.anims.thawing;
	    },
	
	
		unfreezeMe: function() {
		    this.isThawing = false;
		    this.isFrozen = false;
		    this.frozenTimer = null;
			this.currentAnim = this.anims.moving;
	    }
		
				
});

});