
ig.module(
	'game.entities.floatingscore'
)
.requires(
	'impact.entity'
)
.defines(function(){



EntityFloatingscore = ig.Entity.extend({
	lifetime: 0.5,
	fadetime: 0.5,
    gravityFactor : 0,
	vel: {x: 0, y: -20},
	text: "0",
	largeFont: false,
	redFont: false,
	

    init: function( x, y, settings ) {
		this.parent( x, y, settings );
        this.text = settings.text;
        this.idleTimer = new ig.Timer();
		
				
		if (settings.lifetime)
			this.lifetime = settings.lifetime;
			
		if (settings.largeFont)
			this.largeFont = settings.largeFont;
		
		if (settings.redFont)
			this.redFont = settings.redFont;
			
		if (settings.centreScreen)
			if (settings.centreScreen == true)
			{
				var textWidth;
				if (this.largeFont)
					textWidth = ig.game.font.widthForString(settings.text);
				else
					textWidth = ig.game.smallfont.widthForString(settings.text);
				
				this.pos.x = (240 - textWidth) /2;
			}
	},
    
    
    
    draw: function() {
        this.parent();
		if (this.largeFont)
			ig.game.font.draw( this.text, this.pos.x + 1, this.pos.y + 2 );
		else
		{
			if (this.redFont)
				ig.game.redfont.draw( this.text, this.pos.x + 1, this.pos.y + 2 );
			else
				ig.game.smallfont.draw( this.text, this.pos.x + 1, this.pos.y + 2 );
		}
    },
    
    
    update: function() {
			
			if( this.idleTimer.delta() > this.lifetime ) {
				this.kill();
				return;
			}
			this.alpha = this.idleTimer.delta().map(this.lifetime - this.fadetime, this.lifetime, 1, 0);
			this.parent();
	}
    
    
});

});