/*
The EntityDebris will randomly spawn a certain count of EntityDebrisParticle 
entities for a certain duration.

The spawn position of the EntityDebrisParticle is inside the area occupied
by the EntityDebris entity. I.e. make the EntityDebris larger in Weltmeister
to increase the area in which particles will spawn.

Keys for Weltmeister:

duration
	Duration in seconds over which to spawn EntityDebrisParticle entities.
	Default: 5
	
count
	Total count of particles to spawn during the #duration# time span.
	Default: 5
*/

ig.module(
	'game.entities.fruitspawner'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function(){

EntityFruitspawner = ig.Entity.extend({
		_wmScalable: true,
		_wmDrawBox: true,
		_wmBoxColor: 'rgba(255, 50, 200, 1)',
		
		name: 'FruitSpawner',
		size: {x: 8, y: 8},
		count: 40,
		numFruitDropped: 0,
		droppingFruit: false,
		
		soundFruitdrop: new ig.Sound( 'media/soundFruitdrop.*'),
		
		
		init: function( x, y, settings ) {
				this.parent( x, y, settings );
		},
		
		
		triggeredBy: function( entity, trigger ) {
				this.soundFruitdrop.play();
				this.droppingFruit = true;
				ig.game.screenShaker.timedShake(50, 0);
		},
		
		
		update: function(){		
				if( this.droppingFruit && this.numFruitDropped < this.count ) {
					this.numFruitDropped += 1;
					
					var x = Math.random().map( 0,1, this.pos.x, this.pos.x+this.size.x );
					var y = Math.random().map( 0,1, this.pos.y, this.pos.y+this.size.y );
					
					ig.game.spawnEntity( EntityFruitParticle, x, y );
					
				}
		}
});





EntityFruitParticle = ig.Entity.extend({
		
		name : "Fruit",
		bounciness: 0.5,
		vel: {x: 400, y: 50},
		size: { x: 6, y: 8 },
		offset: {x: 1, y: 0},
		minBounceVelocity: 0,
		score: 100,
		
		type: ig.Entity.TYPE.B,
		checkAgainst: ig.Entity.TYPE.A,
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		friction: {x:10, y: 0},
		
		animSheet: null, 
		
		
		init: function( x, y, settings) {
			this.parent( x, y, settings );
			
			this.vel.x = (Math.random() * 2 - 1) * this.vel.x;	
			this.vel.y = (Math.random() * 2 - 1) * this.vel.y;

			if (ig.game.fruittype == "cherry")
			{
				this.animSheet = new ig.AnimationSheet( 'media/cherry.png', 8, 8 );
			}
			else if (ig.game.fruittype == "lemon")
			{
				this.animSheet = new ig.AnimationSheet( 'media/lemon.png', 8, 8 );
			}
			else if (ig.game.fruittype == "orange")
			{
				this.animSheet = new ig.AnimationSheet( 'media/orange.png', 8, 8 );
			}
			else if (ig.game.fruittype == "apple")
			{
				this.animSheet = new ig.AnimationSheet( 'media/apple.png', 8, 8 );
			}
			else if (ig.game.fruittype == "grape")
			{
				this.animSheet = new ig.AnimationSheet( 'media/grape.png', 8, 8 );
			}
			else if (ig.game.fruittype == "strawberry")
			{
				this.animSheet = new ig.AnimationSheet( 'media/strawberry.png', 8, 8 );
			}
			
			this.addAnim( 'idle', 1, [0] );
			this.currentAnim = this.anims.idle;

		},
	
	
	
		update: function() {
			//Keep fruit within bounds of play area
			if (this.pos.x > (ig.game.screenWidth-2))
			{
				this.pos.x = 0;
			}
			if (this.pos.x < 0)
			{
				this.pos.x = (ig.game.screenWidth-2);
			}
			if (this.pos.y > ig.game.screenHeight)
			{
				this.pos.y = 0;
			}
			
			this.parent();
		},
	
		
		
		
		check: function( other ) {
			if (other.name == 'Player')
				{
				    other.fruitCollected += 1;
					ig.game.soundPickup.play();
					this.kill();
					ig.game.spawnEntity( EntityFloatingscore, this.pos.x, this.pos.y, {text : this.score.toString()} );
					ig.game.currentScore += this.score;
				}
		}
		
});



});