ig.module(
	'game.entities.ghost'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityGhost = ig.Entity.extend({
		name: 'Ghost',
		size: {x: 24, y: 20},
		offset: {x: 0, y: 0},
		maxVel: {x: 100, y: 100},
		friction: {x: 150, y: 0},
        gravityFactor : 0,
        ydir : 1,
        yspeed : 10,
		
		type: ig.Entity.TYPE.B, 					// Evil enemy group
		checkAgainst: ig.Entity.TYPE.A, 			// Check for collisions against friendly group
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		health: 100,
		speed: 20,
		flip: false,
		
		animSheet: new ig.AnimationSheet( 'media/ghost.png', 24, 20 ),
		
		
		init: function( x, y, settings ) {
			this.parent( x, y, settings );
			this.addAnim( 'float', 0.1, [0,1,2,3] );
            this.speed = this.speed + Math.floor(Math.random()*40);
            this.currentAnim.alpha = 0.8;
				
            //Start with a random x direction    
            var direction = (Math.random() * 2 - 1);
            if (direction > 0) {
                this.flip = !this.flip;
                this.currentAnim.flip.x = this.flip;
            }
            
            //Start with a random y speed
            this.yspeed = Math.random()*20;
		},
		
		
		update: function() {
            var xdir = this.flip ? -1 : 1;
            this.vel.x = this.speed * xdir;

            //Random change y movement
            var change = Math.random()*500
            if (change < 10)
            {
                this.ydir = -this.ydir;
                this.yspeed = Math.random()*20;
            }
                
            this.vel.y = this.yspeed * this.ydir;
            
            
            this.parent();
		},
		
		
		handleMovementTrace: function( res ) {
            this.parent( res );
            
            //Collision with a wall? return!
            if( res.collision.x ) {
                this.flip = !this.flip;
                this.currentAnim.flip.x = this.flip;
            }
		},	
		
		
		check: function( other ) {
			if (other.name == 'Player')
				{
						// Take some score off
						ig.game.reducePlayerScore(10, false);
						ig.game.soundHit.play();
				}
		},
		

		
		
});

});