
ig.module(
	'game.entities.glass'
)
.requires(
	'impact.entity',
    'game.entities.particle'
)
.defines(function(){


EntityGlass = ig.Entity.extend({
		
		name : "Glass",
		bounciness: 0.1,
		vel: {x: 0, y: 0},
		size: { x: 8, y: 12 },
		offset: {x: 0, y: 0},
		score: 500,
		
		onRightConveyor : false,
		onLeftConveyor : false,
		
		type: ig.Entity.TYPE.B,
		checkAgainst: ig.Entity.TYPE.A,
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		friction: {x:100, y: 100},
		detonationTimer: null,
		detonation: 0,
		
		animSheet:new ig.AnimationSheet( 'media/glass.png', 8, 12 ),
		
		
		init: function( x, y, settings) {
			this.parent( x, y, settings );
			
			this.addAnim('strawberry', 1, [0]);
            this.addAnim('apple', 1, [1]);
            this.addAnim('grape', 1, [2]);
            this.addAnim('lemon', 1, [3]);
            this.addAnim('orange', 1, [4]);
            this.addAnim('cherry', 1, [5]);
			 this.addAnim('bad', 1, [6]);
            
			var flavour = Math.random()*7;
		
            if (flavour < 1)
				this.currentAnim = this.anims.strawberry;
            if (flavour >= 1 && flavour < 2)
				this.currentAnim = this.anims.apple;
            if (flavour >= 2 && flavour < 3)
				this.currentAnim = this.anims.grape;
            if (flavour >= 3 && flavour < 4)
				this.currentAnim = this.anims.lemon;
            if (flavour >= 4 && flavour < 5)
				this.currentAnim = this.anims.orange;
            if (flavour >5 && flavour < 6)
				this.currentAnim = this.anims.cherry;
		    if (flavour >6)
				this.currentAnim = this.anims.bad;
                
            this.friction.x = 50 + Math.random() * 50;
		},
	
	
	
		update: function() {
			//If drops off bottom or sides of screen then kill it
            if (this.pos.y > ig.game.screenHeight)
			{
                this.kill();
				ig.game.glassesKilled += 1;
			}
            if ((this.pos.x > ig.game.screenWidth) || (this.pos.x < 0))
			{
                this.kill();
				ig.game.glassesKilled += 1;
			}
			
			//Move if on conveyor
			if (this.onRightConveyor)
				this.accel.x += 500;
			else if (this.onLeftConveyor)
				this.accel.x -= 500;
            else this.accel.x = 0;
						
			//Move!
			this.parent();
			
			//As there is no way to tell when the player is NOT colliding with a conveyor, instead we assume not and set the flag to false
			//If we are still on a conveyor this will get set back to true by the conveyor collision check method before next update
			this.onRightConveyor = false;
			this.onLeftConveyor = false;
		},
		
		
		
		check: function( other ) {
			if (other.name == 'Player')
				{
				    this.kill();
					ig.game.glassesKilled += 1;
					if (this.currentAnim == this.anims.bad)
					{
						ig.game.soundYuck.play();
						ig.game.reducePlayerScore(3000, true);
					}
					else
					{
						ig.game.soundPickup.play();
						ig.game.spawnEntity( EntityFloatingscore, this.pos.x, this.pos.y, {text : this.score.toString()} );
						ig.game.currentScore += this.score;
					}
				}
		}
	
		
});


});