ig.module(
	'game.entities.glassspawner'
)
.requires(
	'impact.entity',
	'game.entities.glass'
)
.defines(function(){

EntityGlassspawner = ig.Entity.extend({
		_wmScalable: true,
		_wmDrawBox: true,
		_wmBoxColor: 'rgba(255, 250, 250, 0.9)',
		
		size: {x: 8, y: 8},
		
		delayTimer: null,
        delay:  1,
		count: 50,
		numGlassesDropped: 0,
		
		
		init: function( x, y, settings ) {
			this.parent( x, y, settings );
			
			this.delayTimer = new ig.Timer();
		},
		
		
		update: function(){
            if( this.numGlassesDropped < this.count ) {
					
				if( this.delayTimer.delta() > this.delay) {
				    this.numGlassesDropped += 1;
					ig.game.spawnEntity( EntityGlass, this.pos.x, this.pos.y );
					this.delay = Math.random().map( 0, 1, 0, 1);
					this.delayTimer.set(0);
				}
				
			}
			
		}
});



});