ig.module(
	'game.entities.granite'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityGranite = ig.Entity.extend({
    
    name : 'Granite',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 32, y: 32},
    zIndex: -1000,
    gravityFactor: 10,

    type: ig.Entity.TYPE.B, 							
	checkAgainst: ig.Entity.TYPE.A, 					// Check for collisions against player
	collides: ig.Entity.COLLIDES.PASSIVE,	

    dropping: false,
    dropTimer: null,
    delay:  1,
	
    animSheet: new ig.AnimationSheet( 'media/granite.png', 32, 32 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'idle', 1, [0] );
        this.dropTimer = new ig.Timer();
    },
    

    
    update: function() {
        this.parent();
        
        if (!this.dropping)
        {
            if( this.dropTimer.delta() > this.delay) {
                    this.gravityFactor = 10;
                    this.dropping = true
                    this.maxVel.y = Math.random().map(0, 1, 100, 500);
            }
        }
    },
	

	check: function( other ) {
		if (other.name == 'Player')
			{
                if (this.dropping == false && (Math.abs(this.vel.y) < 1) && this.pos.y > 100)
                {
					ig.game.soundHit.play();
                    ig.game.reducePlayerScore(1000, true);
                }
			}
	},
    
    
    handleMovementTrace: function( res ) {
            this.parent( res );
            
            //Collision with a floor? Then splat!
            if( res.collision.y ) {
                if (this.maxVel.y > 0)
                {
                    ig.game.soundGranite.play();
                    ig.game.screenShaker.timedShake(50, 0);
                    this.dropping = false;
                    this.gravityFactor = 0;
                    this.maxVel.y = -100;
                    
                    //Reset drop timer
                    this.delay = Math.random().map( 0, 1, 0, 6);
					this.dropTimer.set(0);
                }
                
                
            }
	}

	
});

});