ig.module(
	'game.entities.hobo'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function () {

    EntityHobo = ig.Entity.extend({

        name: 'Hobo',

        // The hobos (collision) size is a bit smaller than the animation frames, so we have to move the collision box a bit (offset)
        size: { x: 8, y: 14 },
        offset: { x: 4, y: 2 },

        maxVel: { x: 70, y: 150 },
        friction: { x: 500, y: 0 },
		health: 100,

        flip: false,
        accelGround: 400,
        accelAir: 200,
        jump: 170,
		
        type: ig.Entity.TYPE.A, 										// Player friendly collision group
        checkAgainst: ig.Entity.TYPE.NONE,
        collides: ig.Entity.COLLIDES.PASSIVE,

        animSheet: new ig.AnimationSheet('media/hobo.png', 16, 16),
        soundJump: new ig.Sound('media/soundJump.*'),


		//***********************
		// Initialise
		//***********************
        init: function (x, y, settings) {
            this.parent(x, y, settings);

            // Add the animations
            this.addAnim('idle', 1, [0]);
            this.addAnim('run', 0.07, [0, 1, 2, 3]);
            this.addAnim('jump', 1, [1]);
            this.addAnim('fall', 1, [1]);
			this.addAnim('happy', 1, [4]);
            this.addAnim('sleepy', 1, [5]);
			this.addAnim('singing', 1, [6]);
            
            this.currentAnim = this.anims.sleepy;
        },

		
		//***********************
		// Update
		//***********************
        update: function () {
			
            //Move!
            this.parent();
			
        },


    });



   



});