ig.module(
	'game.entities.icecube'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityIcecube = ig.Entity.extend({
    
    name : 'Icecube',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 8, y: 8},
    zIndex: -1000,

    type: ig.Entity.TYPE.B, 							
	checkAgainst: ig.Entity.TYPE.A, 					// Check for collisions against player
	collides: ig.Entity.COLLIDES.PASSIVE,	
    
	
    animSheet: new ig.AnimationSheet( 'media/icecube.png', 8, 8 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'idle', 0.1, [0,1] );
    },
    

    
    update: function() {
        this.parent();
    },
	
	
	
	//Collision check
	check: function( other ) {
		if (other.name == 'Player')
			{
				this.kill();
				ig.game.freezeLevel();
			}
	}

	
});

});