ig.module(
	'game.entities.icegunspawner'
)
.requires(
	'impact.entity',
	'game.entities.icegun'
)
.defines(function(){

EntityIcegunspawner = ig.Entity.extend({
		_wmScalable: true,
		_wmDrawBox: true,
		_wmBoxColor: 'rgba(255, 50, 250, 0.9)',
		
		size: {x: 8, y: 8},
		
		delayTimer: null,
        delay:  1,
		
		
		init: function( x, y, settings ) {
			this.parent( x, y, settings );
			this.delayTimer = new ig.Timer();
		},
		
		
		update: function(){
				
				if (ig.game.levelComplete)
					this.kill();
					
			
				if( this.delayTimer.delta() > this.delay) {
					
					var gun = ig.game.getEntitiesByType( EntityIcegun )[0];
					
					if (!gun)
					{
						//Spawn a new gun at a random position
						ig.game.spawnEntity( EntityIcegun, this.pos.x, this.pos.y );
						gun = ig.game.getEntitiesByType( EntityIcegun )[0];
						gun.pos.x = Math.random().map( 0, 1, 16, 304);	
						gun.pos.y = Math.random().map( 0, 1, 16, 160);
					}
					else
					{
						//Else just remove existing gun
						gun.pos.x = Math.random().map( 0, 1, 16, 304);	
						gun.pos.y = Math.random().map( 0, 1, 16, 160);
					}
					
					this.delay = Math.random().map( 0, 1, 0, 15);
					this.delayTimer.set(0);
				}
			
			
		}
});



});