ig.module(
	'game.entities.iceshot'
)
.requires(
	'impact.entity'
)
.defines(function () {

   

EntityIceshot = ig.Entity.extend({
    name: 'Iceshot',
    size: { x: 8, y: 2 },
    offset: { x: 0, y: 0 },
    maxVel: { x: 200, y: 200 },
    gravityFactor: 0,
    spawnPoint: { x: 0, y: 0 },

    type: ig.Entity.TYPE.A,
    checkAgainst: ig.Entity.TYPE.B, 				
    collides: ig.Entity.COLLIDES.PASSIVE,

    animSheet: new ig.AnimationSheet('media/iceshot.png', 8, 2),


    init: function (x, y, settings) {
        this.parent(x, y, settings);

        //Remember where this shot was spawned
        this.spawnPoint.x = x;
        this.spawnPoint.y = y;

        //Decide what direction to move
        this.vel.x = (settings.flip ? -this.maxVel.x : this.maxVel.x);
        this.vel.y = 0;
        this.addAnim('idle', 0.1, [0, 1]);
        this.currentAnim.flip.x = settings.flip;
    },


    update: function () {
			
        //If the shot has ventured too far from the original spawn point then kill it
        this.parent();

        if (Math.abs(this.pos.x - this.spawnPoint.x) > 150)
            this.kill();

    },
    
    
    
    handleMovementTrace: function( res ) {
        //Collision with a wall? kill shot
        if( res.collision.x ) 
            this.kill();
        
         this.parent( res );
	},	

    
    


    check: function (other) {
        if (other.type == ig.Entity.TYPE.B) {
			
			//If enemy can be frozen then freeze them
            if (!other.isFrozen)
                if (other.freezeMe)
				{
				    other.freezeMe();
					this.kill();
				}
				
			if (!other.isZapped)
                if (other.zapMe)
				{
				    other.zapMe();
					this.kill();
				}
				
			if (other.name == "Boss")
			{
				//Spawn bad fruit off the boss when shot
				if (other.zapMe)
				{
				    other.zapMe();
					this.kill();
				}
			}
        }
       
    },




});



});