
ig.module(
	'game.entities.juicebar'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityJuicebar = ig.Entity.extend({
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(0, 200, 100, 0.7)',
	
    name: 'Juicebar',
	size: {x: 8, y: 40},
    gravityFactor : 0,
	
    
    animSheet: new ig.AnimationSheet('media/juicebar.png', 8, 40),

	juiceCollected : 0,
    amountToFill : 0,
    fruittype : "cherry",

 

    init: function (x, y, settings) {
        this.parent(x, y, settings);

        // Add the animations
        this.addAnim('idle', 1, [0]);
 
    },

    
    
	update: function(){
        
        //If we've collected enough juice then the level is complete
		
		if (this.juiceCollected >= ig.game.numFruit)
		{
			ig.game.levelCompleted();
		}
		else
		{
			//Fill the bar gradually over several frames
			if (this.amountToFill > 0)
			{
			    this.juiceCollected += 0.2;
			    this.amountToFill -= 0.2;
			}	
		}
        
        
        this.parent();
    },
    
    
    
    draw: function() {
		
        if (ig.game.fruittype == "cherry")
        {
            ig.system.context.fillStyle = "#FF0050";
        }
		else if (ig.game.fruittype == "orange")
		{
			ig.system.context.fillStyle = "#FFAE00";
		}
		else if (ig.game.fruittype == "lemon")
		{
			ig.system.context.fillStyle = "#F7FF19";
		}
		else if (ig.game.fruittype == "apple")
		{
			ig.system.context.fillStyle = "#5AAF1D";
		}
		else if (ig.game.fruittype == "grape")
		{
			ig.system.context.fillStyle = "#9700E2";
		}
		else if (ig.game.fruittype == "strawberry")
		{
			ig.system.context.fillStyle = "#FF1900";
		}
        
        ig.system.context.beginPath();
        ig.system.context.rect(
            (this.pos.x-ig.game.screen.x) * ig.system.scale,
            ((this.pos.y + this.size.y - ig.game.screen.y) - this.juiceCollected ) * ig.system.scale,
            this.size.x * ig.system.scale, 
            this.juiceCollected  * ig.system.scale
        );
        ig.system.context.closePath();
        ig.system.context.fill();
        
        this.parent();
       
    }
    
    
    
    
});

});