
ig.module(
	'game.entities.juicedropspawner'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function(){

EntityJuicedropspawner = ig.Entity.extend({
		_wmScalable: true,
		_wmDrawBox: true,
		_wmBoxColor: 'rgba(255, 50, 50, 1)',
		
		name: "Juicedrops",
		
		size: {x: 8, y: 8},
		duration: 1,
		count: 30,
		
		durationTimer: null,
		nextEmit: null,
		
		
		init: function( x, y, settings ) {
			this.parent( x, y, settings );
			this.durationTimer = new ig.Timer();
			this.nextEmit = new ig.Timer();
		},
		
		
		triggeredBy: function( entity, trigger ) {
			this.durationTimer.set( this.duration );
			this.nextEmit.set( 0 );
		},
        
		
		
		update: function(){		
			if( this.durationTimer.delta() < 0 && this.nextEmit.delta() >= 0 ) {
				this.nextEmit.set( this.duration / this.count );
				
				var x = this.pos.x; 
				var y = this.pos.y; 
				
				ig.game.spawnEntity( EntityJuicedrop, x, y );
			}
			
		}
});





EntityJuicedrop = EntityParticle.extend({
		name : 'juicedrop',
		lifetime: 3,
		fadetime: 1,
		bounciness: 0.5,
		vel: {x: 100, y: -200},
		size: { x: 1, y: 1 },
		offset: {x: 1, y: 0},
	
		checkAgainst: ig.Entity.TYPE.NONE, 					
	
		init: function( x, y, settings ) {
				
			if (ig.game.fruittype == "cherry")
			{
				this.animSheet = new ig.AnimationSheet( 'media/cherrydrop.png', 2, 2 );
			}
			else if (ig.game.fruittype == "lemon")
			{
				this.animSheet = new ig.AnimationSheet( 'media/lemondrop.png', 2, 2 );
			}
			else if (ig.game.fruittype == "orange")
			{
				this.animSheet = new ig.AnimationSheet( 'media/orangedrop.png', 2, 2 );
			}
			else if (ig.game.fruittype == "apple")
			{
				this.animSheet = new ig.AnimationSheet( 'media/appledrop.png', 2, 2 );
			}
			else if (ig.game.fruittype == "grape")
			{
				this.animSheet = new ig.AnimationSheet( 'media/grapedrop.png', 2, 2 );
			}
			else if (ig.game.fruittype == "strawberry")
			{
				this.animSheet = new ig.AnimationSheet( 'media/strawberrydrop.png', 2, 2 );
			}
				
				
			this.addAnim( 'idle', 1, [0] );
			this.currentAnim = this.anims.idle;
			this.parent( x, y, settings );
		},
		
		update: function () {
			this.parent();
		},
		
});




});