ig.module(
	'game.entities.juicemachine'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityJuicemachine = ig.Entity.extend({
    
    name : 'JuiceMachine',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 24, y: 16},

    type: ig.Entity.TYPE.C, 							
	checkAgainst: ig.Entity.TYPE.A, 					// Check for collisions against player
	collides: ig.Entity.COLLIDES.PASSIVE,	
    
	
    animSheet: new ig.AnimationSheet( 'media/juicemachine.png', 24, 16 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'moving', 0.1, [0,1,2,3] );
    },
    

    
    update: function() {
        this.parent();
    },
	
	
	
	//Collision check
	check: function( other ) {
		if (other.name == 'Player')
			{
				if (other.fruitCollected > 0)
				{
					ig.game.soundGurgle.play();
					
					//Manually trigger the juicedrop spawner
					var juicedropspawner = ig.game.getEntityByName('Juicedrops');
					juicedropspawner.triggeredBy( this, null );
					
					//Fill the juicebar
					var juicebar = ig.game.getEntityByName('Juicebar');
					juicebar.amountToFill += other.fruitCollected;
					
					other.fruitCollected = 0;
					
					
				}
				
			}
	}

	
});

});