ig.module(
	'game.entities.laser'
)
.requires(
	'impact.entity'
)
.defines(function () {

   

EntityLaser = ig.Entity.extend({
    name: 'Laser',
    size: { x: 8, y: 2 },
    offset: { x: 0, y: 0 },
    maxVel: { x: 200, y: 200 },
    gravityFactor: 0,
    spawnPoint: { x: 0, y: 0 },
	enemyName: "",					//Name of enemy entity that shot this laser

    type: ig.Entity.TYPE.B,
    checkAgainst: ig.Entity.TYPE.A, 				
    collides: ig.Entity.COLLIDES.PASSIVE,

    animSheet: new ig.AnimationSheet('media/laser.png', 8, 2),


    init: function (x, y, settings) {
        this.parent(x, y, settings);

        //Remember where this laser was spawned
        this.spawnPoint.x = x;
        this.spawnPoint.y = y;
		
		//Remember which enemy entity is shooting this laser
		this.enemyName = settings.enemyName;

        //Decide what direction to move
        this.vel.x = (settings.flip ? -this.maxVel.x : this.maxVel.x);
        this.vel.y = 0;
        this.addAnim('idle', 0.1, [0, 1]);
        this.currentAnim.flip.x = settings.flip;
    },


    update: function () {
		
		if (ig.game.levelComplete)
			this.kill();
			
        //If the laser has ventured too far from the original spawn point then kill it
        this.parent();

        if (Math.abs(this.pos.x - this.spawnPoint.x) > 150)
        {
            var enemyEntity = ig.game.getEntityByName(this.enemyName);
			if (enemyEntity)
				enemyEntity.shootingLaser = false;
            this.kill();
        }
        

    },
    
    
    
    handleMovementTrace: function( res ) {
        //Collision with a wall? kill laser
        if( res.collision.x ) {
            var enemyEntity = ig.game.getEntityByName(this.enemyName);
			if (enemyEntity)
			{
				enemyEntity.shootingLaser = false;
				this.kill();
			}
        }
        
         this.parent( res );
	},	





    check: function (other) {
        if (other.name == 'Player')
            {
            
             var enemyEntity = ig.game.getEntityByName(this.enemyName);
			 if (enemyEntity)
				enemyEntity.shootingLaser = false;
             this.kill();
			 
			 // Take some score off
			 ig.game.reducePlayerScore(100, true);
			 ig.game.soundHit.play();
        }
       
    },




});



});