/*
This entity calls ig.game.loadLevel() when its triggeredBy() method is called -
usually through an EntityTrigger entity.


Keys for Weltmeister:

level
	Name of the level to load. E.g. "LevelTest1" or just "test1" will load the 
	'LevelTest1' level.
*/

ig.module(
	'game.entities.levelchange'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityLevelchange = ig.Entity.extend({
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(0, 0, 255, 0.7)',
	
	size: {x: 8, y: 8},
	level: null,
	keysRequired: 1,
	
	triggeredBy: function( entity, trigger ) {	
		if( this.level ) {
			
			var levelName = this.level.replace(/^(Level)?(\w)(\w*)/, function( m, l, a, b ) {
				return a.toUpperCase() + b;
			});
			
		
			if (levelName == "Startagain") {
				ig.game.loadTitleScreen();
				ig.game.currentLevelNum = 0;
			}
			else if (levelName == "Startgame")
				ig.game.loadNextLevel();
			else
				ig.game.loadLevel( ig.global['Level'+levelName] );
			

			//If we have already played the intro1 screen play it differently second time around
			if (levelName == "Intro1")
			{
				if (ig.game.intro1Complete == true)
				{
					//Intro1 already played so stop the professor dropping in and let him in on the right instead
					var player = ig.game.getEntityByName('Player');
					if (player)
					{
						player.kill();
						ig.game.spawnEntity( EntityPlayer, 280 , 158 );
					}
					var trig = ig.game.getEntityByName('ConversationTrigger');
					if (trig)
						trig.kill();
				}
			}
			
			if (levelName == "Intro2")
				ig.game.intro1Complete = true;
			
			
			
		}
	},
	
	update: function(){}
});

});