ig.module(
	'game.entities.player'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function () {

    EntityPlayer = ig.Entity.extend({

        name: 'Player',

        // The players (collision) size is a bit smaller than the animation frames, so we have to move the collision box a bit (offset)
        size: { x: 8, y: 14 },
        offset: { x: 4, y: 2 },

        maxVel: { x: 70, y: 150 },
        friction: { x: 500, y: 0 },
		health: 100,

        flip: false,
        accelGround: 400,
        accelAir: 200,
        jump: 170,
		onRightConveyor : false,
		onLeftConveyor : false,
		
        type: ig.Entity.TYPE.A, 										// Player friendly collision group
        checkAgainst: ig.Entity.TYPE.NONE,
        collides: ig.Entity.COLLIDES.PASSIVE,

		fruitCollected : 0,
		
		carryingGun: 		false,
		carryingGunTimer: 	null,
		shootingIceTimer: 	null,
		
        animSheet: new ig.AnimationSheet('media/player.png', 16, 16),
        soundJump: new ig.Sound('media/soundJump.*'),


        


		//***********************
		// Initialise
		//***********************
        init: function (x, y, settings) {
            this.parent(x, y, settings);

            // Add the animations
            this.addAnim('idle', 1, [0]);
            this.addAnim('run', 0.07, [0, 1, 2, 3]);
            this.addAnim('jump', 1, [1]);
            this.addAnim('fall', 1, [1]);
			this.addAnim('zapped', 0.1, [4,5]);
        },

		
		//***********************
		// Update
		//***********************
        update: function () {

            //Move left or right
            var accel = this.standing ? this.accelGround : this.accelAir;


//            if (ig.input.state('left')) {
//                this.accel.x = -accel;
//                this.flip = true;
//            }
//            else if (ig.input.state('right')) {
//                this.accel.x = accel;
//                this.flip = false;
//            }
//            else {
//                this.accel.x = 0;
//            }

            //Accelerometer support for landscape mode
            if (ig.input.accel.y < -1) {
                this.accel.x = -accel;
                this.flip = true;
            }
            else if (ig.input.accel.y > 1) {
                this.accel.x = accel;
                this.flip = false;
            }
            else {
                this.accel.x = 0;
            }


			
			//If the player is on a conveyor belt then increase/decrease acceleration based on conveyors direction
			if (this.onRightConveyor)
				this.accel.x += 450;
			if (this.onLeftConveyor)
				this.accel.x -= 450;
			
				


            //Jump
            if (this.standing && ig.input.state('jump')) {
                this.vel.y = -this.jump;
                this.soundJump.play();
            }
			
			
			//Keep within bounds of play area
			if (this.pos.x > ig.game.screenWidth)
				this.pos.x = 0;
			if (this.pos.x < 0)
				this.pos.x = ig.game.screenWidth;
			if (this.pos.y > ig.game.screenHeight)
				this.pos.y = 0;

            

            //Set the current animation, based on the player's speed
            if (this.vel.y < 0) {
                this.currentAnim = this.anims.jump;
            }
            else if (this.vel.y > 0) {
                this.currentAnim = this.anims.fall;
            }
            else if (this.vel.x != 0) {
                this.currentAnim = this.anims.run;
            }
            else {
                if (this.currentAnim != this.anims.zapped)
					this.currentAnim = this.anims.idle;
            }

            this.currentAnim.flip.x = this.flip;

			
			//If we are carrying gun and the timer hasn't run out then shoot some ice
			if (this.carryingGun)
			{
				if (this.carryingGunTimer.delta() < 10 && !ig.game.levelComplete)
				{
					if (this.shootingIceTimer.delta() > 0.2)
					{
						this.shootingIce = true;	
						ig.game.soundGun.play();
						ig.game.spawnEntity(EntityIceshot, this.pos.x + 2,  this.pos.y + 8, { flip: this.flip });
						this.shootingIceTimer.set(0);
					}
				}
				else
				{
					//Drop gun now that timer has expired
					this.dropGun();
				}
			}
						

            //Move!
            this.parent();
			
			//As there is no way to tell when the player is NOT colliding with a conveyor, instead we assume not and set the flag to false
			//If we are still on a conveyor this will get set back to true by the conveyor collision check method before next update
			this.onRightConveyor = false;
			this.onLeftConveyor = false;	
        },



	
		//***********************
		// Gun stuff
		//***********************
		pickupGun: function() {
			ig.game.soundGunpickup.play();
			this.carryingGun = true;
			this.carryingGunTimer = new ig.Timer();
			this.shootingIceTimer = new ig.Timer();
		},

		dropGun: function() {
			this.carryingGun = false;
			this.shootingIce = false;
			this.carryingGunTimer = null;
			this.shootingIceTimer = null;
		}


    });



   



});