ig.module(
	'game.entities.portal'
)
.requires(
	'impact.entity',
    'game.entities.particle'
)
.defines(function(){
	
EntityPortal = ig.Entity.extend({
	
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(255, 0, 255, 0.9)',
    
    name : 'Portal',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 16, y: 16},
	enteredPortal: false,

	type: ig.Entity.TYPE.C, 							
	checkAgainst: ig.Entity.TYPE.A, 					// Check for collisions against player
	collides: ig.Entity.COLLIDES.PASSIVE,	
    
	
    animSheet: new ig.AnimationSheet( 'media/portal.png', 16, 16 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'idle', 0.05, [0,1,2,3] );
		ig.game.spawnEntity( EntityStarspawner, x, y);

    },
    

    
    update: function() {
        this.parent();
            ig.game.spawnEntity( EntitySparkParticle, this.pos.x+8, this.pos.y+8);
    },
	
	
	
	//If player enters this portal then the level is complete
	check: function( other ) {
		if (ig.game.currentLevelNum < 31)
		{
			if (other.name == 'Player')
				{
					if (!this.enteredPortal)
					{
						ig.game.soundPortal.play();
						this.enteredPortal = true;
						other.kill();
						ig.game.loadNextLevel();
					}
				}
		}
	}

	
});


//The particles to spawn by the EntityBlood. See particle.js for more details.
EntitySparkParticle = EntityParticle.extend({
	lifetime: 0.5,
	fadetime: 0.5,
	bounciness: 0.2,
    offset: {x: 0, y: 0},
    size:   {x: 1, y: 1},
    vel: {x: 50, y: -100},
	
	animSheet: new ig.AnimationSheet( 'media/spark.png', 1, 1 ),
		
	init: function( x, y, settings ) {
		this.addAnim( 'idle', 1, [0] );		
		this.parent( x, y, settings );
        
        if (this.vel.y > 0)
            this.vel.y = 0 - this.vel.y;
	}
});

});