ig.module(
	'game.entities.robot'
)
.requires(
	'impact.entity',
	'game.entities.floatingscore'
)
.defines(function(){
	
EntityRobot = ig.Entity.extend({
		name: 'Robot',
		size: {x: 8, y: 13},
		offset: {x: 4, y: 2},
		maxVel: {x: 50, y: 50},
		friction: {x: 150, y: 0},
        gravityFactor : 0,
        xdir : 1,
		ydir : 2,
        yspeed : 10,
		health: 100,
		speed: 20,
		flip: false,
		score: 1000,
		
		type: ig.Entity.TYPE.B, 					// Evil enemy group
		checkAgainst: ig.Entity.TYPE.A, 			// Check for collisions against friendly group
		collides: ig.Entity.COLLIDES.PASSIVE,
		
		isFrozen:  		false,
		isThawing: 		false,
		frozenTimer:    null,
	
		hasGun: 	    false,
		shootingLaser: 	false,
		shootingLaserTimer: null,
				
		animSheet: new ig.AnimationSheet( 'media/robot.png', 16, 16 ),
		
		
		//***********************
		// Initialise
		//***********************
		init: function( x, y, settings ) {
				this.parent( x, y, settings );
				
				this.addAnim( 'moving', 0.1, [0,1,2,3] );
				this.addAnim( 'frozen', 1, [4] );
				this.addAnim( 'thawing', 0.2, [5,6] );
				
				
				this.speed = this.speed + Math.floor(Math.random()*40);
				
					
				//Start with a random x direction    
				var direction = (Math.random() * 2 - 1);
				if (direction > 0) {
					this.flip = !this.flip;
					this.currentAnim.flip.x = this.flip;
				}
				
				//Start with a random y speed
				this.yspeed = Math.random()*20;
				
				//If robot has a gun then start the timer to time shots
				if (this.hasGun)
						this.shootingLaserTimer = new ig.Timer();
		},
		
		
		
		//***********************
		// Update
		//***********************
		update: function() {
				
				if (ig.game.levelComplete)
					this.kill();
				
		
				if (this.isFrozen)
				{
					if( this.frozenTimer.delta() > 3 )
						if( !this.isThawing )
							this.thawMe();
			 
					if( this.frozenTimer.delta() > 5 )
						this.unfreezeMe();
				}
				else
				{
					//Check to see if we are close to player, if so move toward player and shoot laser
					if (this.playerNearby())
					{
						this.chasePlayer();
									
				        if (this.hasGun)
								if (!this.shootingLaser)
								{
								    if (this.shootingLaserTimer.delta() > 1)
									{
										this.shootingLaser = true;	
										ig.game.soundLaser.play();
										ig.game.spawnEntity(EntityLaser, this.pos.x + 2,  this.pos.y + 8, { flip: this.flip, enemyName: this.name });
										this.shootingLaserTimer.set(0);
									}
								}
					}
					else{
						//Player is not nearby so just move robot normally by doing a  random change in y movement
						var change = Math.random()*500
						if (change < 10)
						{
							this.ydir = -this.ydir;
							this.yspeed = Math.random()*20;
						}
					}
						
					//Move the robot
					this.xdir = this.flip ? -1 : 1;
					this.vel.x = this.speed * this.xdir;
					this.vel.y = this.yspeed * this.ydir;
						
						
					//Keep within bounds of play area
					if (this.pos.x > ig.game.screenWidth)
						this.pos.x = 0;
					
					if (this.pos.x < 0)
						this.pos.x = ig.game.screenWidth;
					
					if (this.pos.y > ig.game.screenHeight)
						this.pos.y = 0;
					
				}
			
			
            this.parent();
		},
		
		
		
		//***********************
		// Freezing / Thawing
		//***********************
		freezeMe: function() {
		    ig.game.soundIce.play();
		    this.currentAnim = this.anims.frozen;
			this.gravityFactor  = 1;
		    this.isThawing = false;
		    this.isFrozen = true;
		    this.frozenTimer = new ig.Timer();
		},
	
	
		thawMe: function() {
	 	    this.isThawing = true;
			this.currentAnim = this.anims.thawing;
	    },
	
	
		unfreezeMe: function() {
		    this.isThawing = false;
		    this.isFrozen = false;
		    this.frozenTimer = null;
			this.gravityFactor = 0;
			this.currentAnim = this.anims.moving;
	    },
		
		
		
		
		
		//***********************
		// Chasing functions
		//***********************
		playerNearby:  function() {
			//Returns true if player is nearby to this robot
			var player = ig.game.getEntityByName('Player');
			
			if (Math.abs(this.pos.y - player.pos.y) < 50)
			{
				if (Math.abs(this.pos.x - player.pos.x) < 100)
				{
				    return true;
				}
			}
			
			return false;
		},
			
		
		
		chasePlayer: function() {
		    var player = ig.game.getEntitiesByType( EntityPlayer )[0];
			if( player ) {
				if (this.pos.x > (player.pos.x+15))
					if (this.xdir == 1)
					{
					    this.xdir = -1;
						this.flip = !this.flip;
						this.currentAnim.flip.x = this.flip;
					};
		
				if (this.pos.x < (player.pos.x-15))
				{
					if (this.xdir == -1)
					{
						this.xdir = 1;
						this.flip = !this.flip;
						this.currentAnim.flip.x = this.flip;
					};
				}
				
				if (this.pos.y > (player.pos.y+15))
					if (this.ydir == 2)
					    this.ydir = -2;
				if (this.pos.y < (player.pos.y-15))
					if (this.ydir == -2)
					    this.ydir = 2;
		
			}
				
		},
		
		
		
		
		
		//***********************
		// Collision functions
		//***********************
		handleMovementTrace: function( res ) {
            this.parent( res );
            
            //Collision with a wall? return!
            if( res.collision.x ) {
                this.flip = !this.flip;
                this.currentAnim.flip.x = this.flip;
            }
		},	
		

		
		check: function( other ) {
			if (other.name == 'Player')
				if (this.isFrozen)
				{
				    ig.game.soundGobbleup.play();
					this.kill();
					ig.game.spawnEntity( EntityFloatingscore, this.pos.x, this.pos.y, {text : this.score.toString()} );
					ig.game.currentScore += this.score;
				}
				else
				{
						// Take some score off
						ig.game.reducePlayerScore(10, false);
						ig.game.soundHit.play();
				}
		},
		

		
		
});

});