
ig.module(
	'game.entities.smokespawner'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function(){

EntitySmokespawner = ig.Entity.extend({
	_wmScalable: true,
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(250, 250, 250, 0.7)',
	
	size: {x: 8, y: 4},
    name: 'Smokespawner',
	duration: 0.1,
	count: 30,
    vel: {x: 10, y: -10},
	
	durationTimer: null,
	nextEmit: null,
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.durationTimer = new ig.Timer();
		this.nextEmit = new ig.Timer();
	},
	
	
	
	update: function(){
			
		if(this.nextEmit.delta() > 0.1 ) {
            this.nextEmit.set(0.5);
            ig.game.spawnEntity( EntitySmokeParticle, this.pos.x, this.pos.y, {velx : this.vel.x, vely: this.vel.y} );
		}
	}
});



EntitySmokeParticle = EntityParticle.extend({
	lifetime: 3,
	fadetime: 3,
	bounciness: 0,
    gravityFactor : 0,
	vel: {x: 10, y: -30},
	
	animSheet: new ig.AnimationSheet( 'media/smoke.png', 8, 8 ),
		
	init: function( x, y, settings ) {
		this.addAnim( 'idle', 1, [0] );		
		this.parent( x, y, settings );
        
        //Override velocity settings
        this.vel.y = settings.vely;
	}
});

});