ig.module(
	'game.entities.squirrel'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntitySquirrel = ig.Entity.extend({
    
    name : 'Squirrel',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 16, y: 16},
    zIndex: -1000,
    playSound: true,
    
    checkAgainst: ig.Entity.TYPE.NONE,
    
    
    soundGoodluck: new ig.Sound( 'media/soundGoodluck.*'),
    soundWelldone: new ig.Sound( 'media/soundWelldone.*'),
    
    animSheet: new ig.AnimationSheet( 'media/squirrel.png', 16, 16 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'idle', 0.2, [0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3] );
        this.playSound = true;
    },
    

    
    update: function() {
        this.parent();
    },
	
    
    triggeredBy: function( entity, trigger ) {
        
        if (entity.name == "Player")
            if (this.playSound == true)
            {
                if (ig.game.currentLevelNum < 30)
                    this.soundGoodluck.play();
                else
                    this.soundWelldone.play();
            
                this.playSound = false;
            }
	},
	
	

});

});