
ig.module(
	'game.entities.starspawner'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function(){

EntityStarspawner = ig.Entity.extend({
	_wmScalable: true,
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(255, 255, 50, 0.7)',
	
	size: {x: 8, y: 8},
    name: 'Starspawner',
	duration: 180,
	count: 30,
    vel: {x: 500, y: -150},
	
	durationTimer: null,
	nextEmit: null,
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		this.durationTimer = new ig.Timer();
		this.nextEmit = new ig.Timer();
		this.durationTimer.set( this.duration );
		this.nextEmit.set( 0 );
	},
	
	
	update: function(){
		
		if( this.durationTimer.delta() < 0 && this.nextEmit.delta() >= 0 ) {
            this.nextEmit.set(Math.random()/8);
            
            var x = Math.random().map( 0,1, this.pos.x, this.pos.x+this.size.x );
            var y = Math.random().map( 0,1, this.pos.y, this.pos.y+this.size.y );
            ig.game.spawnEntity( EntityStarParticle, x, y, {velx : this.vel.x, vely: this.vel.y} );
		}
	}
});



EntityStarParticle = EntityParticle.extend({
	lifetime: 1,
	fadetime: 0.5,
	gravityFactor : 0,
	
	animSheet: new ig.AnimationSheet( 'media/star.png', 8, 8 ),
		
	init: function( x, y, settings ) {
		this.addAnim( 'idle', 0.01, [0,1] );		
		this.parent( x, y, settings );
		
		//Random velocity
		this.vel.x = Math.random().map( 0,1, -200, 200 );
        this.vel.y = Math.random().map( 0,1, -200, 200 );
	}
});

});