ig.module(
	'game.entities.switch'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntitySwitch = ig.Entity.extend({
    
    name : 'Switch',
    maxVel: {x: 0, y: 0},
    offset: {x: 0, y: 0},
    size:   {x: 8, y: 16},
    zIndex: -1000,

    type: ig.Entity.TYPE.C, 							
	checkAgainst: ig.Entity.TYPE.A, 					// Check for collisions against player
	collides: ig.Entity.COLLIDES.PASSIVE,	
    
	
    animSheet: new ig.AnimationSheet( 'media/switch.png', 8, 16 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'off', 1, [0] );
        this.addAnim( 'on', 1, [1] );
    },
    

    
    update: function() {
        this.parent();
    },
	
	
	
	//Collision check
	check: function( other ) {
		if (other.name == 'Player'  || other.name == 'Iceshot')
			{
				this.currentAnim = this.anims.on;				
			}
	}

	
});

});