ig.module(
	'game.entities.title'
)
.requires(
	'impact.entity'
)
.defines(function(){
	
EntityTitle = ig.Entity.extend({
    
    name : 'Title',
    maxVel: {x: 0, y: 100},
    offset: {x: 0, y: 0},
    size:   {x: 240, y: 60},
    zIndex: -1000,
    gravityFactor: 10,

    type: ig.Entity.TYPE.B, 							
	checkAgainst: ig.Entity.TYPE.A, 					// Check for collisions against player
	collides: ig.Entity.COLLIDES.PASSIVE,	


    animSheet: new ig.AnimationSheet( 'media/title.png', 240, 60 ),
    
    
    
    init: function( x, y, settings ) {
        this.parent( x, y, settings );
        this.addAnim( 'idle', 1, [0] );
     },
    

    
    update: function() {
        this.parent();
 
    },
	

	
    handleMovementTrace: function( res ) {
            this.parent( res );
            
            if( res.collision.y ) {
                if (this.maxVel.y > 0)
                {
                    this.maxVel.y = 0;
                    ig.game.soundSplat.play();
                }
                
            }
	}

	
});

});