
ig.module(
	'game.entities.zedspawner'
)
.requires(
	'impact.entity',
	'game.entities.particle'
)
.defines(function(){

EntityZedspawner = ig.Entity.extend({
	_wmScalable: true,
	_wmDrawBox: true,
	_wmBoxColor: 'rgba(250, 250, 250, 0.7)',
	
	size: {x: 8, y: 4},
    name: 'Zedspawner',
	duration: 0.1,
	count: 30,
    vel: {x: 20, y: -5},
	sleeping: true,
	
	durationTimer: null,
	nextEmit: null,
	
	
	init: function( x, y, settings ) {
		this.parent( x, y, settings );
		
		this.durationTimer = new ig.Timer();
		this.nextEmit = new ig.Timer();
	},
	
	
	
	update: function(){
			
		if (this.sleeping)
			if(this.nextEmit.delta() > 0.1 ) {
				this.nextEmit.set(1);
				ig.game.spawnEntity( EntityZedParticle, this.pos.x, this.pos.y, {velx : this.vel.x, vely: this.vel.y} );
			}
	}
});



EntityZedParticle = EntityParticle.extend({
	lifetime: 3,
	fadetime: 3,
	bounciness: 0,
    gravityFactor : 0,
	vel: {x: 10, y: -30},
	
	animSheet: new ig.AnimationSheet( 'media/zed.png', 8, 8 ),
		
	init: function( x, y, settings ) {
		this.addAnim( 'idle', 1, [0] );		
		this.parent( x, y, settings );
        
        //Override velocity settings
        this.vel.y = settings.vely;
	}
});

});