﻿ig.module( 
	'game.main' 
)
.requires(
	'impact.game',
	'impact.font',
	
	'plugins.screenshaker',
	'plugins.screenfader',

	'game.entities.dialog',
	'game.entities.fruitspawner',
    'game.entities.badfruit',
	'game.entities.juicedropspawner',
	'game.entities.juicemachine',
	'game.entities.portal',
	'game.entities.juicebar',
	'game.entities.smokespawner',
	'game.entities.zedspawner',
	'game.entities.floatingscore',
	'game.entities.starspawner',
	'game.entities.hobo',
	'game.entities.robot',
	'game.entities.laser',
	'game.entities.iceshot',
	'game.entities.switch',
	'game.entities.icecube',
	'game.entities.icegun',
	'game.entities.firespawner',
	'game.entities.fire',
	'game.entities.bomb',
	'game.entities.granite',
	'game.entities.conveyor',
	'game.entities.glassspawner',
	'game.entities.torch',
	'game.entities.ghost',
	'game.entities.lift',
	'game.entities.lifttop',
	'game.entities.icegunspawner',
	'game.entities.chatbubble',
	'game.entities.conversation',
	'game.entities.levelchange',
	'game.entities.squirrel',
	
	'game.levels.title',
	'game.levels.intro1',
	'game.levels.intro2',
	'game.levels.ending1',
	'game.levels.ending2',
    'game.levels._1',
	'game.levels._2',
	'game.levels._3',
	'game.levels._4',
	'game.levels._5',
	'game.levels._6',
	'game.levels._7',
	'game.levels._8',
	'game.levels._9',
	'game.levels._10',
	'game.levels._11',	
	'game.levels._12',
	'game.levels._13',
	'game.levels._14',
	'game.levels._15',
	'game.levels._16',
	'game.levels._17',
	'game.levels._18',
	'game.levels._19',
	'game.levels._20',
	'game.levels._21',
    'game.levels._22',
	'game.levels._23',
	'game.levels._24',
	'game.levels._25',
	'game.levels._26',
	'game.levels._27',
	'game.levels._28',
	'game.levels._29',
	'game.levels._30',
	'game.levels._31'
	
	
)
.defines(function(){

  
MyGame = ig.Game.extend({
	
	screenWidth:  320,
	screenHeight: 176,

    cameraLimit: {x: 80, y: 16},

    gravity: 300, 									
	clearColor: '#00001f',//'#081E47',

	smallfont: new ig.Font( 'media/04b03.font.png' ),
	redfont: new ig.Font( 'media/04b03_red.font.png' ),
	font: new ig.Font( 'media/amiga.font.png' ),
	
	screenShaker: null,
	screenFader:  null,
	
	//Sounds
    soundYipee: 	new ig.Sound( 'media/soundYipee.*'),
    soundPickup: 	new ig.Sound( 'media/soundPickup.*'),
    soundGunpickup:	new ig.Sound( 'media/soundGunpickup.*'),
    soundGurgle: 	new ig.Sound( 'media/soundGurgle.*'),
	soundLaser: 	new ig.Sound( 'media/soundLaser.*'),
	soundHit: 		new ig.Sound( 'media/soundHit.*'),
    soundGun: 		new ig.Sound( 'media/soundGun.*'),
	soundIce: 		new ig.Sound( 'media/soundIce.*'),
    soundGobbleup: 	new ig.Sound( 'media/soundGobbleup.*'),
    soundLevelcomplete:	new ig.Sound( 'media/soundLevelcomplete.*'),
	soundPortal:	new ig.Sound( 'media/soundPortal.*'),
	soundEvilLaugh: new ig.Sound('media/soundEvillaugh.*'),
	soundMadLaugh:  new ig.Sound('media/soundMadlaugh.*'),
	soundFire: 		new ig.Sound( 'media/soundFire.*'),
	soundEvilJump:  new ig.Sound('media/soundEviljump.*'),
	soundExplosion: new ig.Sound('media/soundExplosion.*'),
	soundSplat:     new ig.Sound('media/soundSplat.*'),
	soundGranite:   new ig.Sound('media/soundGranite.*'),
	soundYuck:      new ig.Sound('media/soundYuck.*'),
	soundZapped:    new ig.Sound('media/soundZapped.*'),
	soundNexttime:  new ig.Sound('media/soundNexttime.*'),
	soundSelect:    new ig.Sound('media/soundSelect.*'),

	
	//Global level variables
	currentScore:    0,
	glassesKilled: 	 0,
	currentLevelNum: 0,
	levelName:		"",
	intro1Complete: false,
	
	timeTaken:		null,
	allotedTime:    120,
	
	fruittype: 		"lemon",
	numFruit:       40,
	
	levelComplete:  false,
	levelCompleteTimer : new ig.Timer(),
	exitPortalSpawned: false,
	
	levelFrozen:  	false,
	levelThawing: 	false,
	frozenTimer:    null,
	

	//***********************
	// Initialise stuff
	//***********************
	init: function () {

	
		//Screenshaker plugin
		this.screenShaker = new ScreenShaker();
		
		this.timeTaken = new ig.Timer();
		
		//Music
		ig.music.add( 'media/musicTitle.*', 'Title' );
		ig.music.add( 'media/musicBirds.*', 'Birds' );
		ig.music.add( 'media/musicNemesis.*', 'Nemesis' );
		ig.music.add( 'media/musicSong1.*', 'Song1' );
		ig.music.add( 'media/musicMoonlight.*', 'Moonlight');
		ig.music.add( 'media/musicBoss.*', 'Boss');
		ig.music.add( 'media/musicEndgame.*', 'Endgame');
		ig.music.add( 'media/musicIpenema.*', 'Ipenema');
		ig.music.add( 'media/musicFruit.*', 'Fruit');
		ig.music.volume = 0.7;
		ig.music.loop = true;
			
		
		//Bind keys
        ig.input.initAccelerometer();
        ig.input.initMouse();
        ig.input.bind( ig.KEY.LEFT_ARROW, 'left' );
        ig.input.bind( ig.KEY.RIGHT_ARROW, 'right' );
        ig.input.bind( ig.KEY.UP_ARROW, 'jump' );
        ig.input.bind( ig.KEY.MOUSE1, 'jump' );
		
	
		
		//Add behaviour to allow a layer of a level to be made invisible
		ig.BackgroundMap.inject({
		    visible: true,
		    draw: function() {
				if (!this.visible) {
					return;
				}
				this.parent();
			}
		});
		
		this.loadTitleScreen();
		//this.loadNextLevel();
		
	},


	refreshTouchControlSettings: function () {
        //Checks local storage and updates joystic touch control settings accordingly
	    if (localStorage.leftHandedControls)
	        if (localStorage.leftHandedControls == "True")
	            this.joystick.leftHandedControls = true;
	        else
	            this.joystick.leftHandedControls = false;
	},

	
	//***********************
	// Update stuff
	//***********************
	update: function() {

	    this.parent();

	    //If we are on the title screen see if we can move to the intro screen
	    if (this.levelName == "Title") {
	        if (ig.input.state('jump')) {
	            this.levelName = "";
	            ig.game.soundSelect.play();
	            ig.music.play('birds');
	            ig.game.loadIntro1Screen();
	        }
	    }
		
		if (this.levelComplete)
		{
				if (this.currentLevelNum < 30)
				  delay = 1;
				else
				  delay = 5;
				  
				if (!this.exitPortalSpawned && this.levelCompleteTimer.delta() > delay)
				{
						this.spawnExitPortal();
						this.exitPortalSpawned = true;
						
						var nemesis = ig.game.getEntityByName('Nemesis');
						if (nemesis)
						    nemesis.kill();
				}
		}
		
		

				
		//Screenshaker
		this.screenShaker.update();
		this.screenShaker.shakeScreen(this.screen);
		
		
		// If level is currently frozen then count down the thaw
		if (this.levelFrozen)
		{
		     if( this.frozenTimer.delta() > 3 )
				if( !this.levelThawing )
					this.thawLevel();
			 
			 if( this.frozenTimer.delta() > 5 )
				this.unfreezeLevel();
		}
		else
		{
		    //Hide frost layer
			ig.game.backgroundMaps[1].visible = false;	
		}
		
		
		//If we are on a bonus level then finish the level when all glass entities have been killed
		if (this.glassesKilled >= 50)
		   this.levelCompleted();



        //Camera follows the player
        var player = this.getEntitiesByType( EntityPlayer )[0];
        if( player ) {
            this.screen.x = player.pos.x - ig.system.width / 2;
            this.screen.y = player.pos.y - ig.system.height / 2;
        }

        //Use the camera limits to lock the camera from moving too far if we get close to the level edges
        if (this.screen.x > this.cameraLimit.x) this.screen.x = this.cameraLimit.x;
        if (this.screen.x < 0) this.screen.x = 0;

        if (this.screen.y > this.cameraLimit.y) this.screen.y = this.cameraLimit.y;
        if (this.screen.y < 0) this.screen.y = 0;
		
		
     },
	
	
	
	
	
	//***********************
	// Draw stuff
	//***********************
	draw: function() {
		// Draw all entities and backgroundMaps
		this.parent();
		
		if (this.screenFader) 
		    this.screenFader.draw();
			
		if (this.currentLevelNum > 0 && this.currentLevelNum <32 )
		    this.displayScore();

	    //If we are on the title screen see if we can move to the intro screen
		if (this.levelName == "Title") {
		    ig.game.smallfont.draw("Tilt device Left or Right to move", 10, 120);
			ig.game.smallfont.draw("Tap screen to Jump",10, 130);
		    ig.game.smallfont.draw("Tap to Start", 10, 140);

		}

	},
	
	
	
	displayScore: function() {
		if (this.currentLevelNum<31)
				ig.game.font.draw( this.currentScore.toString(), 1, 1 );
		else 
				ig.game.font.draw( this.currentScore.toString(), 130, 82 );
				
		
	},

	
	
	//***********************
	// Freezing / Thawing
	//***********************
	freezeLevel: function() {
		ig.game.backgroundMaps[1].visible = true;
		
		//Freeze all enemy entities if they have a freeze function
		for( var i = 0; i < this.entities.length; i++ ) {
			var ent = this.entities[i];
			if( ent.type == ig.Entity.TYPE.B ) {
				if (ent.freezeMe)
				   ent.freezeMe();
			}
		}
		
		this.soundIce.play();
		this.levelThawing = false;
		this.levelFrozen = true;
		this.frozenTimer = new ig.Timer();
	},
	
	
	thawLevel: function() {
		this.levelThawing = true;
	},
	
	
	unfreezeLevel: function() {
		ig.game.backgroundMaps[1].visible = false;
		this.levelThawing = false;
		this.levelFrozen = false;
		this.frozenTimer = null;
	},
	
	
	
	//***********************
	// Level Complete
	//***********************
	levelCompleted: function() {
		
		if (!this.levelComplete) {
				
			if (this.currentLevelNum < 30)
			{
				this.soundLevelcomplete.play();
				this.soundYipee.play();
		    }
			else
			{
				ig.music.stop();
				ig.game.soundNexttime.play();
			}
			
			this.levelComplete = true;
		    this.levelCompleteTimer.set(0);
			this.addBonusScore();
			
		}
	},
	
	
	spawnExitPortal: function() {
		var player = ig.game.getEntityByName('Player');

		var x = player.pos.x + 20;
        var y = player.pos.y;
		
		if (x > ig.game.screenWidth - 16)
		    x = player.pos.x - 20
			
		if (y > (ig.game.screenHeight - 16) )
		    y = ig.game.screenHeight - 16;
			
		if (y < 16 )
		    y = 16;

		
		ig.game.spawnEntity( EntityPortal, x, y);
		this.soundPortal.play();

	},
	
	
	
	addBonusScore: function() {
		//See if there is any bonus score to add
		var timeLeft = this.allotedTime - this.timeTaken.delta();
		if (timeLeft > 0)
		{
		    var bonus = (timeLeft * 100).floor();
		    this.currentScore += bonus;
			
		    var machine = ig.game.getEntityByName('JuiceMachine');
            if (machine)
		        ig.game.spawnEntity( EntityFloatingscore, machine.pos.x + 8, machine.pos.y, {text : bonus.toString(), lifetime : 3} );
		}
	},
	
	
	
	//***********************
	// Reduce players score
	//***********************
	reducePlayerScore: function(amount, displayAmount) {
		
		var player = ig.game.getEntityByName('Player');
		player.currentAnim = player.anims.zapped;
		ig.game.currentScore -= amount;
		
		if (displayAmount)
				ig.game.spawnEntity( EntityFloatingscore, player.pos.x-6, player.pos.y-8, {text : -amount.toString(), redFont : true} 									);

    },
	
	
	
	
	//***********************
	//Title Screen
	//***********************
	loadTitleScreen: function() {
		this.clearColor = "#00B6FF";
		this.levelName = "Title";
		this.loadLevel(LevelTitle);
        this.screen.x = 240;
        this.screen.y = 160;
		ig.music.play('Title');
	},
	
  	
	
    //***********************
	// Intro 1 Screen
	//***********************
	loadIntro1Screen: function() {
		
		this.loadLevel(LevelIntro1);
		this.soundPortal.play();
        this.screen.x = 240;
        this.screen.y = 160;
		ig.music.play('Birds');
	},
	
	
	//***********************
	// Load the next level
	//***********************
	loadNextLevel: function() {
		
		//Reset globals for next level
		this.levelComplete = false;
		this.levelFrozen = false;
		this.levelThawing = false;
		this.frozenTimer = null;
		this.exitPortalSpawned = false;
		this.clearColor= '#00001f';
		
		this.currentLevelNum += 1
		
		if (this.currentLevelNum == 1)
		{
				this.fruittype = "cherry";
				this.levelName = "1 Cherries from heaven";
				this.loadLevel(Level_1);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 2)
		{
				this.fruittype = "orange";
				this.levelName = "2 Oranges and Robots on ice";
				this.loadLevel(Level_2);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 3)
		{
				this.fruittype = "lemon";
				this.levelName = "3 Lemons and Lasers";
				this.loadLevel(Level_3);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 4)
		{
				this.fruittype = "apple";
				this.levelName = "4 The apple of my eye";
				this.loadLevel(Level_4);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 5)
		{
				this.fruittype = "grape";
				this.levelName = "5 Galactic Grapes";
				this.loadLevel(Level_5);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 6)
		{
				this.fruittype = "strawberry";
				this.levelName = "6 Sweet sweet Strawberries";
				this.loadLevel(Level_6);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 7)
		{
				this.fruittype = "cherry";
				this.levelName = "7 The Evil Professor";
				this.loadLevel(Level_7);
				ig.music.play('Nemesis');
		}
		else if (this.currentLevelNum == 8)
		{
				this.fruittype = "apple";
				this.levelName = "8 It's getting hot in here";
				this.loadLevel(Level_8);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 9)
		{
				this.fruittype = "grape";
				this.levelName = "9 What goes up...";
				this.loadLevel(Level_9);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 10)
		{
				this.fruittype = "lemon";
				this.levelName = "10 ...must come down";
				this.loadLevel(Level_10);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 11)
		{
				this.fruittype = "lemon";
				this.levelName = "11 Bonus Fruit Drinks!";
				this.loadLevel(Level_11);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 12)
		{
				//After Bonus level so reset glasses killed
				this.glassesKilled = 0;
				
				this.fruittype = "strawberry";
				this.levelName = "12 Weeeeeeeeeeeee!";
				this.loadLevel(Level_12);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 13)
		{
				this.fruittype = "orange";
				this.levelName = "13 Gun ho!";
				this.loadLevel(Level_13);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 14)
		{
				this.fruittype = "cherry";
				this.levelName = "14 Fire and Ice";
				this.loadLevel(Level_14);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 15)
		{
				this.fruittype = "apple";
				this.levelName = "15 Crazy Cuthbert's bombs";
				this.loadLevel(Level_15);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 16)
		{
				this.fruittype = "lemon";
				this.levelName = "16 Kaboooom!";
				this.loadLevel(Level_16);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 17)
		{
				this.fruittype = "strawberry";
				this.levelName = "17 Yuck! Rotten fruit";
				this.loadLevel(Level_17);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 18)
		{
				this.fruittype = "cherry";
				this.levelName = "18 Secret Entrances";
				this.loadLevel(Level_18);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 19)
		{
				this.fruittype = "orange";
				this.levelName = "19 Stepping up";
				this.loadLevel(Level_19);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 20)
		{
				this.fruittype = "grape";
				this.levelName = "20 Fruit Squash";
				this.loadLevel(Level_20);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 21)
		{
				this.fruittype = "lemon";
				this.levelName = "21 They're starting to annoy me...";
				this.loadLevel(Level_21);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 22)
		{
				this.fruittype = "lemon";
				this.levelName = "22 Bonus Fruit Drinks!";
				this.loadLevel(Level_22);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 23)
		{
				//After Bonus level so reset glasses killed
				this.glassesKilled = 0;
				
				this.fruittype = "apple";
				this.levelName = "23 I'm getting a headache";
				this.loadLevel(Level_23);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 24)
		{
				this.fruittype = "cherry";
				this.levelName = "24 Willy, is it really you?";
				this.loadLevel(Level_24);
				ig.music.play('Moonlight');
		}
		else if (this.currentLevelNum == 25)
		{
				this.fruittype = "orange";
				this.levelName = "25 The Furnace Room";
				this.loadLevel(Level_25);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 26)
		{
				this.fruittype = "grape";
				this.levelName = "26 The Tower";
				this.loadLevel(Level_26);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 27)
		{
				this.fruittype = "strawberry";
				this.levelName = "27 Will it never end?";
				this.loadLevel(Level_27);
				ig.music.play('Song1');
		}
		else if (this.currentLevelNum == 28)
		{
				this.fruittype = "lemon";
				this.levelName = "28 The Creepy corridor";
				this.loadLevel(Level_28);
				ig.music.play('Nemesis');
		}
		else if (this.currentLevelNum == 29)
		{
				this.fruittype = "apple";
				this.levelName = "29  Going up...";
				this.loadLevel(Level_29);
				ig.music.play('Ipenema');
		}
		else if (this.currentLevelNum == 30)
		{
				this.fruittype = "apple";
				this.levelName = "The Finale!";
				this.loadLevel(Level_30);
				ig.music.play('Boss');
		}
		else if (this.currentLevelNum == 31)
		{
				this.clearColor= '#00001f';
				this.fruittype = "apple";
				this.levelName = "Congratulations!";
				this.loadLevel(Level_31);
				ig.music.play('Endgame');
		}
		
		if (this.currentLevelNum < 30)
				this.screenFader = new ig.ScreenFader( { fade : 'out', speed: 1.0 } );
		else
				this.screenFader = new ig.ScreenFader( { fade : 'out', speed: 0.5 } );
		
		//Reset the score timer
		this.timeTaken.set(0);
		
		ig.game.spawnEntity( EntityFloatingscore, 0, this.screenHeight/2, {text : this.levelName, lifetime :4, centreScreen : true, largeFont : true} );

	}
	
	
	
});



    // Start the Game
    ig.main('#canvas', MyGame, 60, 320, 176, 2);



});
