var paloslide = new XMLHttpRequest({
  mozSystem: true
});
paloslide.onreadystatechange = function() {
  if (paloslide.readyState == 4 && paloslide.status == 200) {

    function getObjects(obj, key, val) {
      var objects = [];
      for (var i in obj) {
        if (!obj.hasOwnProperty(i)) continue;
        if (typeof obj[i] == 'object') {
          objects = objects.concat(getObjects(obj[i], key, val));
        } else
        //if key matches and value matches or if key matches and value is not passed (eliminating the case where key matches but passed value does not)
        if (i == key && obj[i] == val || i == key && val == '') { //
          objects.push(obj);
        } else if (obj[i] == val && key == '') {
          //only add if the object is not already in the array
          if (objects.lastIndexOf(obj) == -1) {
            objects.push(obj);
          }
        }
      }
      return objects;
    }

    //return an array of values that match on a certain key
    function getValues(obj, key) {
      var objects = [];
      for (var i in obj) {
        if (!obj.hasOwnProperty(i)) continue;
        if (typeof obj[i] == 'object') {
          objects = objects.concat(getValues(obj[i], key));
        } else if (i == key) {
          objects.push(obj[i]);
        }
      }
      return objects;
    }

    //return an array of keys that match on a certain value
    function getKeys(obj, val) {
      var objects = [];
      for (var i in obj) {
        if (!obj.hasOwnProperty(i)) continue;
        if (typeof obj[i] == 'object') {
          objects = objects.concat(getKeys(obj[i], val));
        } else if (obj[i] == val) {
          objects.push(i);
        }
      }
      return objects;
    }
    var data = JSON.parse(paloslide.response);
    var aaluSlideTitle = getValues(data, 'title', '');
    var aaluSlideAuthor = getValues(data, 'author_display_name', '');
    var aaluSlideThumb = getValues(data, 'content_thumbnail_image', '');
    var aaluSlideBanner = getValues(data, 'content_banner_image', '');
    var aaluSlideDate = getValues(data, 'modified_time', '');
    var aaluSlideDetails = getValues(data, 'excerpt', '');
    var aaluSlideLink = getValues(data, 'web_url', '');

    document.getElementById('slide1').innerHTML = '<li><p class="slide_text">' + aaluSlideTitle[0] + '</p>' + '<img class= "slide_img" alt="" src="' + 'http:' + aaluSlideThumb[0] + '" />' + '</li>' ;
    document.getElementById('slide2').innerHTML = '<li><p class="slide_text">' + aaluSlideTitle[1] + '</p>' + '<img class= "slide_img" alt="" src="' + 'http:' + aaluSlideThumb[1] + '" />' + '</li>' ;
    document.getElementById('slide3').innerHTML = '<li><p class="slide_text">' + aaluSlideTitle[2] + '</p>' + '<img class= "slide_img" alt="" src="' + 'http:' + aaluSlideThumb[2] + '" />' + '</li>' ;

    document.getElementById('single8').innerHTML = '<div class="title"><button id="back8" class="back">Back</button><img id ="fb9" class= "head_img" alt="" src="img/fb.png" /><img id ="tw9" class= "head_img" alt="" src="img/tw.png" /><img id ="shr9" class= "head_img" alt="" src="img/plus.png" /><img id="nx9" class= "head_img" alt="" src="img/right.png" /></div><div class="headbar"><h3>' + aaluSlideTitle[0] + '</h3><p>' + aaluSlideAuthor[0] + '<span>' + aaluSlideDate[0] + '</span></p></div><div class="single"><img class= "single_img" alt="" src="http:' + aaluSlideThumb[0] + '" /><p class="single_text">' + aaluSlideDetails[0] + '</span></p></div>';
    document.getElementById('single9').innerHTML = '<div class="title"><button id="back9" class="back">Back</button><img id ="fb10" class= "head_img" alt="" src="img/fb.png" /><img id ="tw10" class= "head_img" alt="" src="img/tw.png" /><img id ="shr10" class= "head_img" alt="" src="img/plus.png" /><img id="nx10" class= "head_img" alt="" src="img/right.png" /></div><div class="headbar"><h3>' + aaluSlideTitle[1] + '</h3><p>' + aaluSlideAuthor[1] + '<span>' + aaluSlideDate[1] + '</span></p></div><div class="single"><img class= "single_img" alt="" src="http:' + aaluSlideThumb[1] + '" /><p class="single_text">' + aaluSlideDetails[1] + '</span></p></div>';
    document.getElementById('single10').innerHTML = '<div class="title"><button id="back10" class="back">Back</button><img id ="fb11" class= "head_img" alt="" src="img/fb.png" /><img id ="tw11" class= "head_img" alt="" src="img/tw.png" /><img id ="shr11" class= "head_img" alt="" src="img/plus.png" /><img id="nx11" class= "head_img" alt="" src="img/right.png" /></div><div class="headbar"><h3>' + aaluSlideTitle[2] + '</h3><p>' + aaluSlideAuthor[2] + '<span>' + aaluSlideDate[2] + '</span></p></div><div class="single"><img class= "single_img" alt="" src="http:' + aaluSlideThumb[2] + '" /><p class="single_text">' + aaluSlideDetails[2] + '</span></p></div>';



    document.getElementById('slide1').addEventListener('click', function() {
      document.getElementById('changable').style.display = 'none';
      document.getElementById('single8').style.display = 'block';

    });
    document.getElementById('slide2').addEventListener('click', function() {
      document.getElementById('changable').style.display = 'none';
      document.getElementById('single9').style.display = 'block';

    });

    document.getElementById('slide3').addEventListener('click', function() {
      document.getElementById('changable').style.display = 'none';
      document.getElementById('single10').style.display = 'block';

    });

    document.getElementById('back8').addEventListener('click', function() {
      document.getElementById('changable').style.display = 'block';
      document.getElementById('single8').style.display = 'none';
    });
    document.getElementById('back9').addEventListener('click', function() {
      document.getElementById('changable').style.display = 'block';
      document.getElementById('single9').style.display = 'none';
    });
    document.getElementById('back10').addEventListener('click', function() {
      document.getElementById('changable').style.display = 'block';
      document.getElementById('single10').style.display = 'none';
    });

    document.getElementById('nx9').addEventListener('click', function() {
      document.getElementById('single9').style.display = 'block';
      document.getElementById('single8').style.display = 'none';
    });
    document.getElementById('nx10').addEventListener('click', function() {
      document.getElementById('single10').style.display = 'block';
      document.getElementById('single9').style.display = 'none';
    });
    document.getElementById('nx11').addEventListener('click', function() {
      document.getElementById('single8').style.display = 'block';
      document.getElementById('single10').style.display = 'none';
    });


    document.getElementById('shr9').addEventListener('click', function(){

      new MozActivity({
            name: "share",
            data: {
                type: 'url',
                url: aaluSlideLink[0]
            }
        });

    });

    document.getElementById('shr10').addEventListener('click', function(){

      new MozActivity({
            name: "share",
            data: {
                type: 'url',
                url: aaluSlideLink[1]
            }
        });

    });

    document.getElementById('shr11').addEventListener('click', function(){

      new MozActivity({
            name: "share",
            data: {
                type: 'url',
                url: aaluSlideLink[2]
            }
        });

    });

    document.getElementById('fb9').addEventListener('click', function() {

      new MozActivity({
        name: "view",
        data: {
          type: 'url',
          url: 'https://www.facebook.com/sharer/sharer.php?u=' + aaluLink[0]
        }
      });

    });

    document.getElementById('fb10').addEventListener('click', function() {

      new MozActivity({
        name: "view",
        data: {
          type: 'url',
          url: 'https://www.facebook.com/sharer/sharer.php?u=' + aaluLink[1]
        }
      });

    });

    document.getElementById('fb11').addEventListener('click', function() {

      new MozActivity({
        name: "view",
        data: {
          type: 'url',
          url: 'https://www.facebook.com/sharer/sharer.php?u=' + aaluLink[2]
        }
      });

    });

    document.getElementById('tw9').addEventListener('click', function() {

      new MozActivity({
        name: "view",
        data: {
          type: 'url',
          url: 'https://twitter.com/intent/tweet?url=' + aaluLink[0]
        }
      });

    });

    document.getElementById('tw10').addEventListener('click', function() {

      new MozActivity({
        name: "view",
        data: {
          type: 'url',
          url: 'https://twitter.com/intent/tweet?url=' + aaluLink[1]
        }
      });

    });

    document.getElementById('tw11').addEventListener('click', function() {

      new MozActivity({
        name: "view",
        data: {
          type: 'url',
          url: 'https://twitter.com/intent/tweet?url=' + aaluLink[2]
        }
      });
    
    });

  }
}
paloslide.open("GET", "http://walleto.com.bd/FFApps/featured-news.php", true);
paloslide.send();
